<?php
session_start();
require_once __DIR__ . '/../koneksi/koneksi.php'; // Pastikan path ini benar

// Cek apakah admin sudah login
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$page_title = "Data Survei Kepuasan Layanan";
$message = $_SESSION['message'] ?? '';
$message_type = $_SESSION['message_type'] ?? '';
unset($_SESSION['message'], $_SESSION['message_type']);

//======================================================================
// DEFINISI FUNGSI DISPLAY RATING (HANYA SATU KALI DI SINI)
//======================================================================
if (!function_exists('generate_star_display')) { // Menggunakan nama yang berbeda dan pengecekan
    function generate_star_display($rating_value, $max_stars = 5) {
        $stars_html = '';
        for ($i = 1; $i <= $max_stars; $i++) {
            $stars_html .= ($i <= $rating_value) ? '<i class="bi bi-star-fill rating-stars"></i>' : '<i class="bi bi-star rating-stars"></i>';
        }
        return $stars_html . " <span class='small text-muted'>(" . intval($rating_value) . "/" . $max_stars . ")</span>";
    }
}
//======================================================================

// Handle Aksi Hapus (jika ada)
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id_kepuasan_to_delete = filter_var($_GET['id'], FILTER_VALIDATE_INT);
    if ($id_kepuasan_to_delete) {
        $sql_delete = "DELETE FROM tb_kepuasan WHERE id_kepuasan = ?";
        if ($stmt_delete = $koneksi->prepare($sql_delete)) {
            $stmt_delete->bind_param("i", $id_kepuasan_to_delete);
            if ($stmt_delete->execute()) {
                $_SESSION['message'] = "Data survei kepuasan berhasil dihapus.";
                $_SESSION['message_type'] = "success";
            } else {
                $_SESSION['message'] = "Gagal menghapus data survei: " . $stmt_delete->error;
                $_SESSION['message_type'] = "danger";
            }
            $stmt_delete->close();
        } else {
            $_SESSION['message'] = "Gagal menyiapkan statement hapus survei: " . $koneksi->error;
            $_SESSION['message_type'] = "danger";
        }
        header("Location: data_kepuasan.php");
        exit;
    } else {
        $_SESSION['message'] = "ID survei tidak valid untuk dihapus.";
        $_SESSION['message_type'] = "danger";
        header("Location: data_kepuasan.php");
        exit;
    }
}

// Fetch semua data survei kepuasan
$survei_list = [];
$sql_select_survei = "SELECT id_kepuasan, id_tamu_fk, nama_responden, tanggal_survei, waktu_survei, 
                             nilai_pelayanan, nilai_fasilitas, nilai_keramahan, nilai_kecepatan, saran_masukan 
                      FROM tb_kepuasan 
                      ORDER BY tanggal_survei DESC, waktu_survei DESC";
$result_survei = $koneksi->query($sql_select_survei);
if ($result_survei && $result_survei->num_rows > 0) {
    while ($row = $result_survei->fetch_assoc()) {
        $survei_list[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?> - Admin Buku Tamu</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }
        .navbar-admin { background-color: #0E5CAD; color: white; }
        .navbar-admin .navbar-brand, .navbar-admin .nav-link { color: white !important; }
        .navbar-admin .dropdown-item { color: #212529 !important; }
        .navbar-admin .nav-link:hover { color: #79F1A4 !important; }
        .navbar-admin .dropdown-item:hover { background-color: #f8f9fa; color: #0E5CAD !important; }
        .navbar-admin .navbar-toggler-icon { filter: invert(1); }
        .navbar-admin .navbar-toggler { border-color: rgba(255,255,255,0.3); }
        .sidebar { height: 100vh; position: fixed; top: 0; left: -250px; width: 250px; padding-top: 56px; background-color: #343a40; color: white; z-index: 1020; transition: left 0.3s ease-in-out; }
        .sidebar.active { left: 0; }
        .sidebar .nav-link { color: #adb5bd; padding: 0.85rem 1.25rem; display: flex; align-items: center; font-size: 0.95rem; }
        .sidebar .nav-link i { margin-right: 0.8rem; font-size: 1.1rem; width: 20px; text-align: center; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { color: white; background-color: #495057; }
        .sidebar .sidebar-header { padding: 1.3rem 1.25rem; text-align: center; border-bottom: 1px solid #495057; font-weight: 600; }
        .main-content { padding-top: calc(56px + 1.5rem); padding-left: 1.5rem; padding-right: 1.5rem; padding-bottom: 1.5rem; transition: margin-left 0.3s ease-in-out; }
        @media (min-width: 768px) { .sidebar { left: 0; } .main-content { margin-left: 250px; } .navbar-admin .navbar-toggler#sidebarToggleBtn { display: none; } }
        .table-responsive { margin-top: 1rem; }
        .action-buttons .btn { margin-right: 5px; }
        .rating-stars { color: #ffc107; } 
        .saran-preview { max-width: 200px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; }
    </style>
</head>
<body>
    <?php
    if (file_exists(__DIR__ . '/_partials/navbar.php')) { include_once __DIR__ . '/_partials/navbar.php'; }
    if (file_exists(__DIR__ . '/_partials/sidebar.php')) { include_once __DIR__ . '/_partials/sidebar.php'; }
    ?>

    <main class="main-content">
        <div class="container-fluid">
        <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><?php echo htmlspecialchars($page_title); ?></h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="export_kepuasan.php" class="btn btn-outline-success">
            <i class="bi bi-file-earmark-excel-fill"></i> Ekspor ke CSV (Excel)
        </a>
    </div>
</div>

            <?php if ($message): ?>
            <div class="alert alert-<?php echo $message_type === 'success' ? 'success' : ($message_type === 'danger' ? 'danger' : 'info'); ?> alert-dismissible fade show" role="alert">
                <?php echo htmlspecialchars($message); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>

            <div class="card shadow-sm">
                <div class="card-header">
                    <h5 class="mb-0">Daftar Survei Kepuasan</h5>
                </div>
                <div class="card-body">
                    <?php if (!empty($survei_list)): ?>
                    <div class="table-responsive">
                        <table id="tabelDataSurvei" class="table table-striped table-hover table-bordered">
                            <thead class="table-dark">
                                <tr>
                                    <th>No.</th>
                                    <th>Tanggal</th>
                                    <th>Responden</th>
                                    <th>Pelayanan</th>
                                    <th>Fasilitas</th>
                                    <th>Keramahan</th>
                                    <th>Kecepatan</th>
                                    <th>Saran (Singkat)</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $nomor = 1; foreach ($survei_list as $survei): ?>
                                <tr>
                                    <td><?php echo $nomor++; ?></td>
                                    <td><?php echo htmlspecialchars(date('d M Y, H:i', strtotime($survei['tanggal_survei'] . ' ' . $survei['waktu_survei']))); ?></td>
                                    <td><?php echo htmlspecialchars($survei['nama_responden'] ?: ($survei['id_tamu_fk'] ? 'Tamu ID: '.$survei['id_tamu_fk'] : 'Anonim')); ?></td>
                                    <td><?php echo generate_star_display($survei['nilai_pelayanan']); // Panggil fungsi yang sudah didefinisikan di atas ?></td>
                                    <td><?php echo generate_star_display($survei['nilai_fasilitas']); ?></td>
                                    <td><?php echo generate_star_display($survei['nilai_keramahan']); ?></td>
                                    <td><?php echo generate_star_display($survei['nilai_kecepatan']); ?></td>
                                    <td class="saran-preview" title="<?php echo htmlspecialchars($survei['saran_masukan']); ?>">
                                        <?php echo htmlspecialchars(mb_strimwidth($survei['saran_masukan'], 0, 50, "...")); ?>
                                    </td>
                                    <td class="action-buttons">
                                        <a href="detail_kepuasan.php?id=<?php echo $survei['id_kepuasan']; ?>" class="btn btn-sm btn-info" title="Lihat Detail Survei"><i class="bi bi-eye-fill"></i></a>
                                        <a href="data_kepuasan.php?action=delete&id=<?php echo $survei['id_kepuasan']; ?>"
                                           class="btn btn-sm btn-danger" title="Hapus Survei"
                                           onclick="return confirm('Apakah Anda yakin ingin menghapus data survei ini?');">
                                           <i class="bi bi-trash-fill"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="alert alert-info" role="alert">
                        Belum ada data survei kepuasan yang tersimpan.
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main>

    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#tabelDataSurvei').DataTable({
                "language": { "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json" },
                "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Semua"]],
                "pageLength": 10,
                "order": [[ 1, "desc" ]] 
            });
        });

        const sidebarToggleBtn = document.getElementById('sidebarToggleBtn');
        const adminSidebar = document.getElementById('adminSidebar');
        if (sidebarToggleBtn && adminSidebar) {
            sidebarToggleBtn.addEventListener('click', function() {
                adminSidebar.classList.toggle('active');
            });
        }
    </script>
</body>
</html>