<?php
session_start();
require_once __DIR__ . '/../koneksi/koneksi.php'; // Sesuaikan path jika berbeda

// Cek apakah admin sudah login
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$page_title = "Data Kunjungan Tamu";
$message = $_SESSION['message'] ?? ''; // Ambil pesan dari session
$message_type = $_SESSION['message_type'] ?? ''; // Ambil tipe pesan
unset($_SESSION['message'], $_SESSION['message_type']); // Hapus pesan setelah ditampilkan

// Handle Aksi Hapus
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id_tamu_to_delete = filter_var($_GET['id'], FILTER_VALIDATE_INT);
    if ($id_tamu_to_delete) {
        $sql_delete = "DELETE FROM tb_tamu WHERE id_tamu = ?";
        if ($stmt_delete = $koneksi->prepare($sql_delete)) {
            $stmt_delete->bind_param("i", $id_tamu_to_delete);
            if ($stmt_delete->execute()) {
                $_SESSION['message'] = "Data tamu berhasil dihapus.";
                $_SESSION['message_type'] = "success";
            } else {
                $_SESSION['message'] = "Gagal menghapus data tamu: " . $stmt_delete->error;
                $_SESSION['message_type'] = "danger";
            }
            $stmt_delete->close();
        } else {
            $_SESSION['message'] = "Gagal menyiapkan statement hapus: " . $koneksi->error;
            $_SESSION['message_type'] = "danger";
        }
        header("Location: data_tamu.php"); // Redirect untuk refresh dan menghilangkan parameter GET
        exit;
    } else {
        $_SESSION['message'] = "ID tamu tidak valid untuk dihapus.";
        $_SESSION['message_type'] = "danger";
        header("Location: data_tamu.php");
        exit;
    }
}


// Fetch semua data tamu, diurutkan berdasarkan tanggal dan waktu terbaru dulu
$tamu_list = [];
$sql_select_tamu = "SELECT id_tamu, tanggal_kunjungan, waktu_masuk, nama_tamu, asal_instansi, bertemu_dengan, keperluan, waktu_keluar FROM tb_tamu ORDER BY tanggal_kunjungan DESC, waktu_masuk DESC";
$result_tamu = $koneksi->query($sql_select_tamu);
if ($result_tamu && $result_tamu->num_rows > 0) {
    while ($row = $result_tamu->fetch_assoc()) {
        $tamu_list[] = $row;
    }
}

// $koneksi->close(); // Sebaiknya tidak ditutup di sini jika ada operasi lain setelahnya,
                  // atau jika halaman ini meng-include file lain yang butuh koneksi.
                  // PHP akan menutupnya otomatis di akhir skrip.
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?> - Admin Buku Tamu</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }
        .navbar-admin { background-color: #0E5CAD; color: white; }
        .navbar-admin .navbar-brand, .navbar-admin .nav-link { color: white !important; }
        .navbar-admin .dropdown-item { color: #212529 !important; }
        .navbar-admin .nav-link:hover { color: #79F1A4 !important; }
        .navbar-admin .dropdown-item:hover { background-color: #f8f9fa; color: #0E5CAD !important; }
        .navbar-admin .navbar-toggler-icon { filter: invert(1); }
        .navbar-admin .navbar-toggler { border-color: rgba(255,255,255,0.3); }
        .sidebar { height: 100vh; position: fixed; top: 0; left: -250px; width: 250px; padding-top: 56px; background-color: #343a40; color: white; z-index: 1020; transition: left 0.3s ease-in-out; }
        .sidebar.active { left: 0; }
        .sidebar .nav-link { color: #adb5bd; padding: 0.85rem 1.25rem; display: flex; align-items: center; font-size: 0.95rem; }
        .sidebar .nav-link i { margin-right: 0.8rem; font-size: 1.1rem; width: 20px; text-align: center; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { color: white; background-color: #495057; }
        .sidebar .sidebar-header { padding: 1.3rem 1.25rem; text-align: center; border-bottom: 1px solid #495057; font-weight: 600; }
        .main-content { padding-top: calc(56px + 1.5rem); padding-left: 1.5rem; padding-right: 1.5rem; padding-bottom: 1.5rem; transition: margin-left 0.3s ease-in-out; }
        @media (min-width: 768px) { .sidebar { left: 0; } .main-content { margin-left: 250px; } .navbar-admin .navbar-toggler#sidebarToggleBtn { display: none; } }
        .table-responsive { margin-top: 1rem; }
        .action-buttons .btn { margin-right: 5px; }
    </style>
</head>
<body>
    <?php
    if (file_exists(__DIR__ . '/_partials/navbar.php')) { include_once __DIR__ . '/_partials/navbar.php'; }
    if (file_exists(__DIR__ . '/_partials/sidebar.php')) { include_once __DIR__ . '/_partials/sidebar.php'; }
    ?>

    <main class="main-content">
        <div class="container-fluid">
        <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><?php echo htmlspecialchars($page_title); ?></h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="export_tamu.php" class="btn btn-outline-success me-2">
            <i class="bi bi-file-earmark-excel-fill"></i> Ekspor ke CSV (Excel)
        </a>
        
        </div>
</div>

            <?php if ($message): ?>
            <div class="alert alert-<?php echo $message_type === 'success' ? 'success' : 'info'; ?> alert-dismissible fade show" role="alert">
                <?php echo htmlspecialchars($message); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>

            <div class="card shadow-sm">
                <div class="card-header">
                    <h5 class="mb-0">Daftar Kunjungan Tamu</h5>
                </div>
                <div class="card-body">
                    <?php if (!empty($tamu_list)): ?>
                    <div class="table-responsive">
                        <table id="tabelDataTamu" class="table table-striped table-hover table-bordered">
                            <thead class="table-dark">
                                <tr>
                                    <th>No.</th>
                                    <th>Tanggal</th>
                                    <th>Waktu Masuk</th>
                                    <th>Nama Tamu</th>
                                    <th>Asal Instansi</th>
                                    <th>Bertemu Dengan</th>
                                    <th>Keperluan</th>
                                    <th>Waktu Keluar</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $nomor = 1; foreach ($tamu_list as $tamu): ?>
                                <tr>
                                    <td><?php echo $nomor++; ?></td>
                                    <td><?php echo htmlspecialchars(date('d M Y', strtotime($tamu['tanggal_kunjungan']))); ?></td>
                                    <td><?php echo htmlspecialchars($tamu['waktu_masuk']); ?></td>
                                    <td><?php echo htmlspecialchars($tamu['nama_tamu']); ?></td>
                                    <td><?php echo htmlspecialchars($tamu['asal_instansi']); ?></td>
                                    <td><?php echo htmlspecialchars($tamu['bertemu_dengan']); ?></td>
                                    <td><?php echo nl2br(htmlspecialchars($tamu['keperluan'])); ?></td>
                                    <td><?php echo htmlspecialchars($tamu['waktu_keluar'] ?? '-'); ?></td>
                                    <td class="action-buttons">
                                    <a href="detail_tamu.php?id=<?php echo $tamu['id_tamu']; ?>" class="btn btn-sm btn-info" title="Lihat Detail Tamu">
    <i class="bi bi-eye-fill"></i>
</a>
<a href="edit_tamu.php?id=<?php echo $tamu['id_tamu']; ?>" class="btn btn-sm btn-warning" title="Edit Data Tamu">
    <i class="bi bi-pencil-fill"></i>
                                </a>
                                        <a href="data_tamu.php?action=delete&id=<?php echo $tamu['id_tamu']; ?>" 
                                           class="btn btn-sm btn-danger" title="Hapus Data" 
                                           onclick="return confirm('Apakah Anda yakin ingin menghapus data tamu ini?');">
                                           <i class="bi bi-trash-fill"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="alert alert-info" role="alert">
                        Belum ada data kunjungan tamu yang tersimpan.
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main>

    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#tabelDataTamu').DataTable({
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json" // Untuk bahasa Indonesia
                },
                "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Semua"]],
                "pageLength": 10 // Jumlah entri default per halaman
            });
        });

        // Script untuk toggle sidebar di mobile (jika menggunakan tombol khusus)
        const sidebarToggleBtn = document.getElementById('sidebarToggleBtn');
        const adminSidebar = document.getElementById('adminSidebar');
        if (sidebarToggleBtn && adminSidebar) {
            sidebarToggleBtn.addEventListener('click', function() {
                adminSidebar.classList.toggle('active');
            });
        }
    </script>
</body>
</html>