<?php
session_start();
require_once __DIR__ . '/../koneksi/koneksi.php'; // Sesuaikan path jika berbeda

// Cek apakah admin sudah login
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$page_title = "Detail Kunjungan Tamu";
$tamu_detail = null;
$error_message = '';

if (isset($_GET['id']) && filter_var($_GET['id'], FILTER_VALIDATE_INT)) {
    $id_tamu_to_view = $_GET['id'];

    // Fetch detail data tamu
    // Memilih semua kolom yang relevan dari tb_tamu
    $sql_select_detail = "SELECT id_tamu, tanggal_kunjungan, waktu_masuk, nama_tamu, 
                                 asal_instansi, jabatan, no_telepon, email_tamu, 
                                 bertemu_dengan, keperluan, catatan_tambahan, 
                                 foto_tamu, tanda_tangan, status_keluar, waktu_keluar, created_at 
                          FROM tb_tamu 
                          WHERE id_tamu = ?";
    
    if ($stmt_detail = $koneksi->prepare($sql_select_detail)) {
        $stmt_detail->bind_param("i", $id_tamu_to_view);
        $stmt_detail->execute();
        $result_detail = $stmt_detail->get_result();
        if ($result_detail->num_rows === 1) {
            $tamu_detail = $result_detail->fetch_assoc();
        } else {
            $error_message = "Data tamu tidak ditemukan.";
            // Simpan pesan error di session untuk ditampilkan setelah redirect
            $_SESSION['message'] = $error_message;
            $_SESSION['message_type'] = "danger";
            header("Location: data_tamu.php");
            exit;
        }
        $stmt_detail->close();
    } else {
        $error_message = "Gagal menyiapkan statement untuk mengambil detail tamu: " . $koneksi->error;
        // Tampilkan error ini atau redirect dengan pesan
        error_log("SQL Prepare error for detail_tamu: " . $koneksi->error);
        $_SESSION['message'] = "Terjadi kesalahan saat mengambil data.";
        $_SESSION['message_type'] = "danger";
        header("Location: data_tamu.php");
        exit;
    }
} else {
    $_SESSION['message'] = "ID tamu tidak valid atau tidak disediakan.";
    $_SESSION['message_type'] = "warning";
    header("Location: data_tamu.php");
    exit;
}

// $koneksi->close(); // Ditutup otomatis
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title) . ($tamu_detail ? ' - ' . htmlspecialchars($tamu_detail['nama_tamu']) : ''); ?> - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* Salin CSS yang sama dari halaman admin lain atau buat file CSS terpusat */
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }
        .navbar-admin { background-color: #0E5CAD; color: white; }
        .navbar-admin .navbar-brand, .navbar-admin .nav-link { color: white !important; }
        .navbar-admin .dropdown-item { color: #212529 !important; }
        .navbar-admin .nav-link:hover { color: #79F1A4 !important; }
        .navbar-admin .dropdown-item:hover { background-color: #f8f9fa; color: #0E5CAD !important; }
        .navbar-admin .navbar-toggler-icon { filter: invert(1); }
        .navbar-admin .navbar-toggler { border-color: rgba(255,255,255,0.3); }
        .sidebar { height: 100vh; position: fixed; top: 0; left: -250px; width: 250px; padding-top: 56px; background-color: #343a40; color: white; z-index: 1020; transition: left 0.3s ease-in-out; }
        .sidebar.active { left: 0; }
        .sidebar .nav-link { color: #adb5bd; padding: 0.85rem 1.25rem; display: flex; align-items: center; font-size: 0.95rem; }
        .sidebar .nav-link i { margin-right: 0.8rem; font-size: 1.1rem; width: 20px; text-align: center; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { color: white; background-color: #495057; }
        .sidebar .sidebar-header { padding: 1.3rem 1.25rem; text-align: center; border-bottom: 1px solid #495057; font-weight: 600; }
        .main-content { padding-top: calc(56px + 1.5rem); padding-left: 1.5rem; padding-right: 1.5rem; padding-bottom: 1.5rem; transition: margin-left 0.3s ease-in-out; }
        @media (min-width: 768px) { .sidebar { left: 0; } .main-content { margin-left: 250px; } .navbar-admin .navbar-toggler#sidebarToggleBtn { display: none; } }
        
        .detail-label { font-weight: 600; color: #495057; }
        .detail-value { color: #212529; }
        .detail-group { margin-bottom: 0.8rem; }
        .foto-tamu-detail, .tandatangan-tamu-detail { max-width: 250px; max-height: 250px; border: 1px solid #dee2e6; border-radius: 0.375rem; margin-top: 0.5rem; }
    </style>
</head>
<body>
    <?php
    if (file_exists(__DIR__ . '/_partials/navbar.php')) { include_once __DIR__ . '/_partials/navbar.php'; }
    if (file_exists(__DIR__ . '/_partials/sidebar.php')) { include_once __DIR__ . '/_partials/sidebar.php'; }
    ?>

    <main class="main-content">
        <div class="container-fluid">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2"><?php echo htmlspecialchars($page_title); ?></h1>
                <a href="data_tamu.php" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left-circle"></i> Kembali ke Daftar Tamu
                </a>
            </div>

            <?php if ($error_message && !$tamu_detail): // Tampilkan error jika tamu_detail tidak berhasil di-fetch ?>
            <div class="alert alert-danger" role="alert">
                <?php echo htmlspecialchars($error_message); ?>
            </div>
            <?php endif; ?>

            <?php if ($tamu_detail): ?>
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Detail Tamu: <?php echo htmlspecialchars($tamu_detail['nama_tamu']); ?></h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="detail-group">
                                <span class="detail-label">ID Tamu:</span>
                                <span class="detail-value"><?php echo $tamu_detail['id_tamu']; ?></span>
                            </div>
                            <div class="detail-group">
                                <span class="detail-label">Tanggal Kunjungan:</span>
                                <span class="detail-value"><?php echo htmlspecialchars(date('d F Y', strtotime($tamu_detail['tanggal_kunjungan']))); ?></span>
                            </div>
                            <div class="detail-group">
                                <span class="detail-label">Waktu Masuk:</span>
                                <span class="detail-value"><?php echo htmlspecialchars($tamu_detail['waktu_masuk']); ?></span>
                            </div>
                            <div class="detail-group">
                                <span class="detail-label">Nama Tamu:</span>
                                <span class="detail-value"><?php echo htmlspecialchars($tamu_detail['nama_tamu']); ?></span>
                            </div>
                            <div class="detail-group">
                                <span class="detail-label">Asal Instansi/Perusahaan:</span>
                                <span class="detail-value"><?php echo htmlspecialchars($tamu_detail['asal_instansi'] ?: '-'); ?></span>
                            </div>
                            <div class="detail-group">
                                <span class="detail-label">Jabatan:</span>
                                <span class="detail-value"><?php echo htmlspecialchars($tamu_detail['jabatan'] ?: '-'); ?></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="detail-group">
                                <span class="detail-label">No. Telepon:</span>
                                <span class="detail-value"><?php echo htmlspecialchars($tamu_detail['no_telepon'] ?: '-'); ?></span>
                            </div>
                            <div class="detail-group">
                                <span class="detail-label">Email:</span>
                                <span class="detail-value"><?php echo htmlspecialchars($tamu_detail['email_tamu'] ?: '-'); ?></span>
                            </div>
                            <div class="detail-group">
                                <span class="detail-label">Bertemu Dengan:</span>
                                <span class="detail-value"><?php echo htmlspecialchars($tamu_detail['bertemu_dengan']); ?></span>
                            </div>
                            <div class="detail-group">
                                <span class="detail-label">Waktu Keluar:</span>
                                <span class="detail-value"><?php echo htmlspecialchars($tamu_detail['waktu_keluar'] ?: 'Belum keluar'); ?></span>
                            </div>
                             <div class="detail-group">
                                <span class="detail-label">Status Kunjungan:</span>
                                <span class="badge bg-<?php echo $tamu_detail['status_keluar'] == 'Keluar' ? 'secondary' : 'success'; ?>">
                                    <?php echo htmlspecialchars($tamu_detail['status_keluar']); ?>
                                </span>
                            </div>
                            <div class="detail-group">
                                <span class="detail-label">Dicatat Pada:</span>
                                <span class="detail-value"><?php echo htmlspecialchars(date('d M Y, H:i:s', strtotime($tamu_detail['created_at']))); ?></span>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="detail-group">
                        <span class="detail-label d-block">Keperluan Kunjungan:</span>
                        <div class="detail-value p-2 bg-light border rounded" style="white-space: pre-wrap;"><?php echo nl2br(htmlspecialchars($tamu_detail['keperluan'])); ?></div>
                    </div>
                    <div class="detail-group mt-2">
                        <span class="detail-label d-block">Catatan Tambahan:</span>
                        <div class="detail-value p-2 bg-light border rounded" style="white-space: pre-wrap;"><?php echo $tamu_detail['catatan_tambahan'] ? nl2br(htmlspecialchars($tamu_detail['catatan_tambahan'])) : '<em>Tidak ada catatan tambahan.</em>'; ?></div>
                    </div>

                    <?php if ($tamu_detail['foto_tamu'] || $tamu_detail['tanda_tangan']): ?>
                    <hr>
                    <div class="row mt-3">
                        <?php if ($tamu_detail['foto_tamu']): ?>
                        <div class="col-md-6">
                            <span class="detail-label d-block">Foto Tamu:</span>
                            <?php 
                                // Asumsikan foto_tamu berisi nama file dan disimpan di folder tertentu
                                // Misalnya: uploads/foto_tamu/namafile.jpg
                                // Untuk sekarang, kita asumsikan path lengkap atau hanya nama file jika di folder yang sama.
                                // Jika Anda memiliki folder khusus, sesuaikan path di bawah.
                                $path_foto_tamu = '../uploads/tamu/' . htmlspecialchars($tamu_detail['foto_tamu']); // Sesuaikan path ini
                                if (file_exists($path_foto_tamu) && !empty($tamu_detail['foto_tamu'])) {
                                    echo '<img src="' . $path_foto_tamu . '" alt="Foto Tamu" class="foto-tamu-detail">';
                                } else {
                                    echo '<span class="detail-value"><em>Foto tidak tersedia (' . htmlspecialchars($tamu_detail['foto_tamu']) . ').</em></span>';
                                }
                            ?>
                        </div>
                        <?php endif; ?>

                        <?php if ($tamu_detail['tanda_tangan']): ?>
                        <div class="col-md-6">
                            <span class="detail-label d-block">Tanda Tangan:</span>
                            <?php
                                // Jika tanda tangan disimpan sebagai data base64:
                                if (strpos($tamu_detail['tanda_tangan'], 'data:image') === 0) {
                                    echo '<img src="' . $tamu_detail['tanda_tangan'] . '" alt="Tanda Tangan" class="tandatangan-tamu-detail">';
                                } 
                                // Jika tanda tangan disimpan sebagai nama file:
                                // $path_ttd_tamu = '../uploads/tandatangan/' . htmlspecialchars($tamu_detail['tanda_tangan']); // Sesuaikan path ini
                                // else if (file_exists($path_ttd_tamu) && !empty($tamu_detail['tanda_tangan'])) {
                                //    echo '<img src="' . $path_ttd_tamu . '" alt="Tanda Tangan" class="tandatangan-tamu-detail">';
                                // } 
                                else {
                                    echo '<span class="detail-value"><em>Tanda tangan tidak tersedia atau format tidak dikenali.</em></span>';
                                }
                            ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>

                </div>
                <div class="card-footer text-end">
                    <a href="data_tamu.php" class="btn btn-secondary"><i class="bi bi-list-ul"></i> Kembali ke Daftar</a>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        const sidebarToggleBtn = document.getElementById('sidebarToggleBtn');
        const adminSidebar = document.getElementById('adminSidebar');
        if (sidebarToggleBtn && adminSidebar) {
            sidebarToggleBtn.addEventListener('click', function() {
                adminSidebar.classList.toggle('active');
            });
        }
    </script>
</body>
</html>