<?php
session_start();
require_once __DIR__ . '/../koneksi/koneksi.php'; // Sesuaikan path jika berbeda

// Cek apakah admin sudah login
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    // Jika tidak login, bisa redirect atau tampilkan error.
    // Untuk ekspor, mungkin lebih baik tidak ada output selain error jika akses ditolak.
    header("HTTP/1.1 403 Forbidden");
    exit("Akses ditolak. Silakan login terlebih dahulu.");
}

// Nama file CSV yang akan di-download
$filename = "daftar_tamu_" . date('Ymd_His') . ".csv";

// Set header HTTP untuk memicu download file CSV
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Pragma: no-cache'); // HTTP/1.0
header('Expires: 0'); // Proxies

// Buka output stream PHP untuk menulis CSV
$output = fopen('php://output', 'w');
if ($output === false) {
    // Gagal membuka output stream
    error_log("Gagal membuka php://output untuk ekspor CSV tamu.");
    exit("Terjadi kesalahan saat mencoba membuat file ekspor.");
}

// Tulis baris header (nama kolom) untuk CSV
// Sesuaikan dengan kolom yang ingin Anda ekspor dari tb_tamu
fputcsv($output, [
    'ID Tamu',
    'Tanggal Kunjungan',
    'Waktu Masuk',
    'Nama Tamu',
    'Asal Instansi',
    'Jabatan',
    'No. Telepon',
    'Email Tamu',
    'Bertemu Dengan',
    'Keperluan',
    'Catatan Tambahan',
    'Status Keluar',
    'Waktu Keluar',
    'Foto Tamu (Filename)', // Hanya nama file
    'Tanda Tangan (Filename)', // Hanya nama file
    'Dicatat Pada (Created At)'
]);

// Query untuk mengambil semua data tamu
// Anda bisa menambahkan filter WHERE jika ingin mengekspor data tertentu saja
$sql_export_tamu = "SELECT 
                        id_tamu, 
                        tanggal_kunjungan, 
                        waktu_masuk, 
                        nama_tamu, 
                        asal_instansi, 
                        jabatan, 
                        no_telepon, 
                        email_tamu, 
                        bertemu_dengan, 
                        keperluan, 
                        catatan_tambahan, 
                        status_keluar, 
                        waktu_keluar,
                        foto_tamu,      -- Nama file foto
                        tanda_tangan,   -- Nama file tanda tangan
                        created_at
                    FROM tb_tamu 
                    ORDER BY tanggal_kunjungan DESC, waktu_masuk DESC";

$result_export = $koneksi->query($sql_export_tamu);

if ($result_export) {
    if ($result_export->num_rows > 0) {
        // Loop melalui setiap baris data dan tulis ke CSV
        while ($row = $result_export->fetch_assoc()) {
            // Urutan data harus sesuai dengan urutan header
            fputcsv($output, [
                $row['id_tamu'],
                $row['tanggal_kunjungan'],
                $row['waktu_masuk'],
                $row['nama_tamu'],
                $row['asal_instansi'],
                $row['jabatan'],
                $row['no_telepon'],
                $row['email_tamu'],
                $row['bertemu_dengan'],
                $row['keperluan'],
                $row['catatan_tambahan'],
                $row['status_keluar'],
                $row['waktu_keluar'],
                $row['foto_tamu'],      // Ekspor nama file
                $row['tanda_tangan'],   // Ekspor nama file (atau data base64 jika disimpan begitu)
                $row['created_at']
            ]);
        }
    } else {
        // Jika tidak ada data, tulis pesan di file CSV (opsional)
        // fputcsv($output, ['Tidak ada data tamu yang ditemukan.']);
        // Atau biarkan file CSV hanya berisi header
    }
    $result_export->free();
} else {
    // Gagal query, bisa catat error
    error_log("Gagal query ekspor data tamu: " . $koneksi->error);
    // Mungkin tulis pesan error ke file CSV jika perlu, tapi biasanya tidak
    // fputcsv($output, ['Error: Gagal mengambil data dari database.']);
}

// Tutup output stream dan koneksi database
fclose($output);
if (isset($koneksi) && $koneksi instanceof mysqli) {
    $koneksi->close();
}
exit; // Pastikan tidak ada output lain setelah ini
?>