<?php
session_start();

// Cek apakah admin sudah login, jika tidak, redirect ke halaman login
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// Memanggil file koneksi DULUAN, karena kita butuh $koneksi
require_once __DIR__ . '/../koneksi/koneksi.php'; // Pastikan path ini benar

// Mengambil nama admin dari session untuk ditampilkan
$admin_nama = htmlspecialchars($_SESSION['admin_nama_lengkap'] ?? ($_SESSION['admin_username'] ?? 'Admin'));
$page_title = "Dashboard Admin";

// Inisialisasi variabel statistik
$total_tamu_hari_ini = 0;
$total_survei_hari_ini = 0;
$total_tamu_bulan_ini = 0;
$total_tamu_keseluruhan = 0;

// Pastikan $koneksi ada dan merupakan objek mysqli yang valid
if (isset($koneksi) && $koneksi instanceof mysqli) {

    // 1. Total Tamu Hari Ini
    $sql_tamu_today = "SELECT COUNT(*) as total FROM tb_tamu WHERE tanggal_kunjungan = CURDATE()";
    $result_tamu_today = $koneksi->query($sql_tamu_today);
    if ($result_tamu_today) {
        $total_tamu_hari_ini = $result_tamu_today->fetch_assoc()['total'] ?? 0;
    } else {
        error_log("Error query total_tamu_hari_ini: " . $koneksi->error);
    }

    // 2. Total Survei Hari Ini
    $sql_survei_today = "SELECT COUNT(*) as total FROM tb_kepuasan WHERE tanggal_survei = CURDATE()";
    $result_survei_today = $koneksi->query($sql_survei_today);
    if ($result_survei_today) {
        $total_survei_hari_ini = $result_survei_today->fetch_assoc()['total'] ?? 0;
    } else {
        error_log("Error query total_survei_hari_ini: " . $koneksi->error);
    }

    // 3. Total Tamu Bulan Ini
    $sql_tamu_month = "SELECT COUNT(*) as total FROM tb_tamu WHERE MONTH(tanggal_kunjungan) = MONTH(CURDATE()) AND YEAR(tanggal_kunjungan) = YEAR(CURDATE())";
    $result_tamu_month = $koneksi->query($sql_tamu_month);
    if ($result_tamu_month) {
        $total_tamu_bulan_ini = $result_tamu_month->fetch_assoc()['total'] ?? 0;
    } else {
        error_log("Error query total_tamu_bulan_ini: " . $koneksi->error);
    }

    // 4. Total Tamu Keseluruhan
    $sql_tamu_all = "SELECT COUNT(*) as total FROM tb_tamu";
    $result_tamu_all = $koneksi->query($sql_tamu_all);
    if ($result_tamu_all) {
        $total_tamu_keseluruhan = $result_tamu_all->fetch_assoc()['total'] ?? 0;
    } else {
        error_log("Error query total_tamu_keseluruhan: " . $koneksi->error);
    }

    // $koneksi->close(); // Tidak perlu ditutup di sini jika masih ada potensi penggunaan di partials atau bagian lain.
                       // PHP akan menutupnya otomatis.
} else {
    // Handle jika $koneksi tidak tersedia (seharusnya tidak terjadi jika require_once berhasil)
    error_log("Variabel koneksi tidak tersedia atau bukan instance mysqli di admin/index.php");
    // Anda bisa set pesan error di sini jika mau
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?> - Buku Tamu Digital</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8f9fa;
        }
        .navbar-admin {
            background-color: #0E5CAD;
            color: white;
        }
        .navbar-admin .navbar-brand,
        .navbar-admin .nav-link {
            color: white !important; 
        }
        .navbar-admin .dropdown-item {
             color: #212529 !important; 
        }
        .navbar-admin .nav-link:hover {
            color: #79F1A4 !important;
        }
         .navbar-admin .dropdown-item:hover {
            background-color: #f8f9fa; 
            color: #0E5CAD !important;
        }
        .navbar-admin .navbar-toggler-icon {
            filter: invert(1);
        }
        .navbar-admin .navbar-toggler {
            border-color: rgba(255,255,255,0.3);
        }

        .sidebar {
            height: 100vh;
            position: fixed;
            top: 0;
            left: -250px; 
            width: 250px;
            padding-top: 56px;
            background-color: #343a40;
            color: white;
            z-index: 1020; 
            transition: left 0.3s ease-in-out;
        }
        .sidebar.active {
            left: 0; 
        }
        .sidebar .nav-link {
            color: #adb5bd;
            padding: 0.85rem 1.25rem;
            display: flex;
            align-items: center;
            font-size: 0.95rem;
        }
        .sidebar .nav-link i {
            margin-right: 0.8rem;
            font-size: 1.1rem;
            width: 20px;
            text-align: center;
        }
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background-color: #495057;
        }
        .sidebar .sidebar-header {
            padding: 1.3rem 1.25rem;
            text-align: center;
            border-bottom: 1px solid #495057;
            font-weight: 600;
        }

        .main-content {
            padding-top: calc(56px + 1.5rem);
            padding-left: 1.5rem;
            padding-right: 1.5rem;
            padding-bottom: 1.5rem;
            transition: margin-left 0.3s ease-in-out;
        }

        @media (min-width: 768px) { 
            .sidebar {
                left: 0; 
            }
            .main-content {
                margin-left: 250px;
            }
            .navbar-admin .navbar-toggler#sidebarToggleBtn { 
                display: none;
            }
        }
         .card-admin-stat .card-body { display: flex; align-items: center; }
        .card-admin-stat .stat-icon { font-size: 2.5rem; margin-right: 1rem; opacity: 0.8; }
        .card-admin-stat .stat-info h5 { margin-bottom: 0.25rem; font-weight: 500; font-size: 0.9rem; }
        .card-admin-stat .stat-info p { font-size: 1.5rem; font-weight: 700; margin-bottom: 0; }
    </style>
</head>
<body>
    <?php
    // Memastikan partials ada sebelum di-include
    if (file_exists(__DIR__ . '/_partials/navbar.php')) {
        include_once __DIR__ . '/_partials/navbar.php';
    } else {
        echo '<nav class="navbar navbar-light bg-light fixed-top"><div class="container-fluid"><span class="navbar-brand mb-0 h1">Error: Navbar partial (_partials/navbar.php) tidak ditemukan.</span></div></nav>';
    }

    if (file_exists(__DIR__ . '/_partials/sidebar.php')) {
        include_once __DIR__ . '/_partials/sidebar.php';
    } else {
        // Fallback sederhana jika sidebar tidak ada
        echo '<div style="width:0; height:0;"></div>'; // Tidak menampilkan error besar agar layout tidak terlalu rusak
        error_log("Peringatan: Sidebar partial (_partials/sidebar.php) tidak ditemukan di admin/index.php");
    }
    ?>

    <main class="main-content">
        <div class="container-fluid">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2"><?php echo htmlspecialchars($page_title); ?></h1>
                 <div class="btn-toolbar mb-2 mb-md-0">
                    </div>
            </div>
            
            <p class="lead">Selamat datang kembali, <?php echo htmlspecialchars($admin_nama); ?>!</p>
            <p>Anda berada di halaman dashboard admin Buku Tamu Digital.</p>

            <div class="row">
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card text-white bg-primary h-100 card-admin-stat">
                        <div class="card-body">
                            <div class="stat-icon"><i class="bi bi-people-fill"></i></div>
                            <div class="stat-info">
                                <h5>Total Tamu (Hari Ini)</h5>
                                <p><?php echo $total_tamu_hari_ini; ?></p>
                            </div>
                        </div>
                         <a href="data_tamu.php" class="card-footer text-white clearfix small z-1 text-decoration-none">
                            <span class="float-start">Lihat Detail</span>
                            <span class="float-end"><i class="bi bi-arrow-right-circle-fill"></i></span>
                        </a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card text-white bg-success h-100 card-admin-stat">
                        <div class="card-body">
                            <div class="stat-icon"><i class="bi bi-patch-check-fill"></i></div>
                            <div class="stat-info">
                                <h5>Total Survei (Hari Ini)</h5>
                                <p><?php echo $total_survei_hari_ini; ?></p>
                            </div>
                        </div>
                        <a href="data_kepuasan.php" class="card-footer text-white clearfix small z-1 text-decoration-none">
                            <span class="float-start">Lihat Detail</span>
                            <span class="float-end"><i class="bi bi-arrow-right-circle-fill"></i></span>
                        </a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card text-white bg-info h-100 card-admin-stat">
                        <div class="card-body">
                             <div class="stat-icon"><i class="bi bi-calendar-event-fill"></i></div>
                            <div class="stat-info">
                                <h5>Total Tamu (Bulan Ini)</h5>
                                <p><?php echo $total_tamu_bulan_ini; ?></p>
                            </div>
                        </div>
                         <a href="data_tamu.php" class="card-footer text-white clearfix small z-1 text-decoration-none">
                            <span class="float-start">Lihat Detail</span>
                            <span class="float-end"><i class="bi bi-arrow-right-circle-fill"></i></span>
                        </a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card text-dark bg-warning h-100 card-admin-stat">
                        <div class="card-body">
                            <div class="stat-icon"><i class="bi bi-journal-richtext"></i></div>
                            <div class="stat-info">
                                <h5>Total Tamu (Semua)</h5>
                                <p><?php echo $total_tamu_keseluruhan; ?></p>
                            </div>
                        </div>
                         <a href="data_tamu.php" class="card-footer text-dark clearfix small z-1 text-decoration-none">
                            <span class="float-start">Lihat Detail</span>
                            <span class="float-end"><i class="bi bi-arrow-right-circle-fill"></i></span>
                        </a>
                    </div>
                </div>
            </div>

            <div class="mt-4">
                <h4>Aktivitas Terbaru:</h4>
                <div class="list-group">
                    <?php
                        // Ambil 3 tamu terakhir sebagai contoh aktivitas
                        $sql_aktivitas = "SELECT nama_tamu, keperluan, waktu_masuk, tanggal_kunjungan FROM tb_tamu ORDER BY tanggal_kunjungan DESC, waktu_masuk DESC LIMIT 3";
                        $result_aktivitas = isset($koneksi) ? $koneksi->query($sql_aktivitas) : null;
                        if ($result_aktivitas && $result_aktivitas->num_rows > 0) {
                            while($aktivitas = $result_aktivitas->fetch_assoc()):
                    ?>
                    <a href="data_tamu.php" class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between">
                            <h5 class="mb-1">Tamu: <?php echo htmlspecialchars($aktivitas['nama_tamu']); ?></h5>
                            <small class="text-muted"><?php echo htmlspecialchars(date('d M Y, H:i', strtotime($aktivitas['tanggal_kunjungan'] . ' ' . $aktivitas['waktu_masuk']))); ?></small>
                        </div>
                        <p class="mb-1">Keperluan: <?php echo nl2br(htmlspecialchars(mb_strimwidth($aktivitas['keperluan'], 0, 100, "..."))); ?></p>
                    </a>
                    <?php
                            endwhile;
                        } else {
                            echo '<div class="list-group-item"><p class="mb-1">Belum ada aktivitas tamu terbaru.</p></div>';
                        }
                    ?>
                </div>
            </div>
        </div>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Toggle sidebar di mobile
        const sidebarToggleBtn = document.getElementById('sidebarToggleBtn'); // Pastikan ID ini ada di tombol toggler navbar
        const adminSidebar = document.getElementById('adminSidebar'); // Pastikan ID ini ada di div sidebar

        if (sidebarToggleBtn && adminSidebar) {
            sidebarToggleBtn.addEventListener('click', function() {
                adminSidebar.classList.toggle('active');
            });
        }
    </script>
</body>
</html>