<?php
session_start(); // Mulai session di awal

// Jika admin sudah login, redirect ke dashboard admin
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header("Location: index.php");
    exit;
}

// Memanggil file koneksi dari parent directory
// Pastikan path ini benar sesuai struktur folder Anda
require_once __DIR__ . '/../koneksi/koneksi.php';

$login_error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (empty(trim($_POST["username"])) || empty(trim($_POST["password"]))) {
        $login_error = "Username dan Password wajib diisi.";
    } else {
        $username = trim($_POST["username"]);
        $password = trim($_POST["password"]); // Password plain text dari form

        $sql = "SELECT id_admin, username, password_hash, nama_lengkap, role FROM tb_admin WHERE username = ?";

        if ($stmt = $koneksi->prepare($sql)) {
            $stmt->bind_param("s", $param_username);
            $param_username = $username;

            if ($stmt->execute()) {
                $stmt->store_result();

                if ($stmt->num_rows == 1) { // Username ditemukan
                    $stmt->bind_result($id_admin, $db_username, $db_password_hash, $nama_lengkap, $role);
                    if ($stmt->fetch()) {
                        // Verifikasi password plain text dengan hash dari database
                        if (password_verify($password, $db_password_hash)) {
                            // Password benar, mulai session baru
                            $_SESSION['admin_logged_in'] = true;
                            $_SESSION['admin_id'] = $id_admin;
                            $_SESSION['admin_username'] = $db_username;
                            $_SESSION['admin_nama_lengkap'] = $nama_lengkap;
                            $_SESSION['admin_role'] = $role;

                            // Update last_login (opsional)
                            $update_sql = "UPDATE tb_admin SET last_login = CURRENT_TIMESTAMP WHERE id_admin = ?";
                            if ($update_stmt = $koneksi->prepare($update_sql)) {
                                $update_stmt->bind_param("i", $id_admin);
                                $update_stmt->execute();
                                $update_stmt->close();
                            }

                            header("Location: index.php"); // Redirect ke dashboard admin
                            exit;
                        } else {
                            $login_error = "Password yang Anda masukkan salah.";
                        }
                    }
                } else {
                    $login_error = "Username tidak ditemukan.";
                }
            } else {
                $login_error = "Oops! Terjadi kesalahan saat eksekusi. Silakan coba lagi nanti.";
                error_log("Admin login execute error: " . $stmt->error);
            }
            $stmt->close();
        } else {
            $login_error = "Oops! Gagal menyiapkan statement. Silakan coba lagi nanti.";
            error_log("Admin login prepare error: " . $koneksi->error);
        }
    }
    // $koneksi->close(); // Sebaiknya tidak ditutup di sini jika halaman masih membutuhkan koneksi setelahnya,
                       // tapi karena ini hanya untuk login, bisa saja ditutup. PHP akan menutup otomatis di akhir skrip.
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin - Buku Tamu Digital</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
        }
        .login-container {
            background-color: white;
            padding: 2.5rem;
            border-radius: 0.75rem;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 420px;
        }
        .login-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        .login-header h2 {
            font-weight: 600;
            color: #0E5CAD;
        }
        .form-control {
            border-radius: 0.375rem;
            padding: 0.85rem 1.1rem;
            border: 1px solid #DEE2E6;
        }
        .form-control:focus {
            border-color: #0E5CAD;
            box-shadow: 0 0 0 0.25rem rgba(14, 92, 173, 0.25);
        }
        .btn-login {
            background: linear-gradient(135deg, #79F1A4, #0E5CAD);
            border: none;
            color: white;
            padding: 0.85rem 1.5rem;
            font-weight: 600;
            border-radius: 0.375rem;
            transition: all 0.3s ease;
        }
        .btn-login:hover {
            filter: brightness(1.1);
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        .alert-danger {
            border-radius: 0.375rem;
        }
        .back-to-site {
            display: block;
            text-align: center;
            margin-top: 1.5rem;
            color: #0E5CAD;
            text-decoration: none;
        }
        .back-to-site:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <h2>Login Admin</h2>
            <p class="text-muted">Buku Tamu Digital</p>
        </div>

        <?php if (!empty($login_error)): ?>
            <div class="alert alert-danger" role="alert">
                <i class="bi bi-exclamation-triangle-fill"></i> <?php echo htmlspecialchars($login_error); ?>
            </div>
        <?php endif; ?>

        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            <div class="mb-3">
                <label for="username" class="form-label">Username</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="bi bi-person-fill"></i></span>
                    <input type="text" class="form-control" id="username" name="username" placeholder="Masukkan username" required
                           value="<?php echo isset($_POST['username']) ? htmlspecialchars($_POST['username']) : ''; ?>">
                </div>
            </div>
            <div class="mb-4">
                <label for="password" class="form-label">Password</label>
                 <div class="input-group">
                    <span class="input-group-text"><i class="bi bi-lock-fill"></i></span>
                    <input type="password" class="form-control" id="password" name="password" placeholder="Masukkan password" required>
                </div>
            </div>
            <div class="d-grid">
                <button type="submit" class="btn btn-login">Login</button>
            </div>
        </form>
        <a href="../index.php" class="back-to-site"><i class="bi bi-arrow-left-circle"></i> Kembali ke Halaman Utama</a>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>