<?php
session_start();
require_once __DIR__ . '/../koneksi/koneksi.php'; // Sesuaikan path jika berbeda

// Cek apakah admin sudah login
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$page_title = "Pengaturan Profil Perusahaan";
$message = '';
$message_type = ''; // 'success' atau 'danger'

// Path untuk menyimpan gambar yang diupload
$upload_dir = __DIR__ . '/images/'; // Pastikan direktori ini ada dan writable

// Fetch current profile data
$profile = null;
$sql_select = "SELECT * FROM tb_profile LIMIT 1";
$result = $koneksi->query($sql_select);
if ($result && $result->num_rows > 0) {
    $profile = $result->fetch_assoc();
} else {
    // Jika tidak ada profil, bisa set default atau berikan pesan error
    // Untuk saat ini, kita anggap profil sudah ada (diinsert saat pembuatan tabel)
    $message = "Data profil tidak ditemukan. Silakan hubungi administrator.";
    $message_type = "danger";
}

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST" && $profile) { // Hanya proses jika profil ada
    $id_profile = $profile['id_profile'];
    $nama_perusahaan = trim($_POST['nama_perusahaan']);
    $alamat = trim($_POST['alamat']);
    $telepon = trim($_POST['telepon']);
    $email = trim($_POST['email']);
    $website = trim($_POST['website']);
    $deskripsi_singkat = trim($_POST['deskripsi_singkat']);
    $visi = trim($_POST['visi']);
    $misi = trim($_POST['misi']);

    // Current image filenames
    $current_foto = $profile['foto'];
    $current_foto2 = $profile['foto2'];

    $new_foto_filename = $current_foto;
    $new_foto2_filename = $current_foto2;

    // Handle file upload untuk 'foto' (logo)
    if (isset($_FILES['foto']) && $_FILES['foto']['error'] == UPLOAD_ERR_OK) {
        $foto_tmp_name = $_FILES['foto']['tmp_name'];
        $foto_name = basename($_FILES['foto']['name']);
        $foto_ext = strtolower(pathinfo($foto_name, PATHINFO_EXTENSION));
        $allowed_ext = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'];

        if (in_array($foto_ext, $allowed_ext)) {
            // Buat nama file unik untuk mencegah penimpaan
            $new_foto_filename = "logo_" . uniqid() . "." . $foto_ext;
            if (move_uploaded_file($foto_tmp_name, $upload_dir . $new_foto_filename)) {
                // Hapus foto lama jika ada dan bukan default, dan nama file baru berbeda
                if ($current_foto && $current_foto != 'default-logo.png' && file_exists($upload_dir . $current_foto) && $current_foto != $new_foto_filename) {
                    unlink($upload_dir . $current_foto);
                }
            } else {
                $message = "Gagal mengupload file logo baru.";
                $message_type = "danger";
                $new_foto_filename = $current_foto; // Kembalikan ke nama lama jika gagal upload
            }
        } else {
            $message = "Format file logo tidak diizinkan. Hanya JPG, JPEG, PNG, GIF, WEBP, SVG.";
            $message_type = "danger";
        }
    }

    // Handle file upload untuk 'foto2' (ilustrasi)
    if (isset($_FILES['foto2']) && $_FILES['foto2']['error'] == UPLOAD_ERR_OK) {
        $foto2_tmp_name = $_FILES['foto2']['tmp_name'];
        $foto2_name = basename($_FILES['foto2']['name']);
        $foto2_ext = strtolower(pathinfo($foto2_name, PATHINFO_EXTENSION));
        // $allowed_ext sudah didefinisikan di atas

        if (in_array($foto2_ext, $allowed_ext)) {
            $new_foto2_filename = "illust_" . uniqid() . "." . $foto2_ext;
            if (move_uploaded_file($foto2_tmp_name, $upload_dir . $new_foto2_filename)) {
                if ($current_foto2 && $current_foto2 != 'default-image.png' && file_exists($upload_dir . $current_foto2) && $current_foto2 != $new_foto2_filename) {
                    unlink($upload_dir . $current_foto2);
                }
            } else {
                $message = "Gagal mengupload file ilustrasi baru.";
                $message_type = "danger";
                $new_foto2_filename = $current_foto2;
            }
        } else {
            $message = "Format file ilustrasi tidak diizinkan. Hanya JPG, JPEG, PNG, GIF, WEBP, SVG.";
            $message_type = "danger";
        }
    }


    if ($message_type !== 'danger') { // Lanjutkan update jika tidak ada error upload sebelumnya
        $sql_update = "UPDATE tb_profile SET 
                        nama_perusahaan = ?, 
                        alamat = ?, 
                        telepon = ?, 
                        email = ?, 
                        website = ?, 
                        foto = ?, 
                        foto2 = ?, 
                        deskripsi_singkat = ?, 
                        visi = ?, 
                        misi = ?
                      WHERE id_profile = ?";
        
        if ($stmt = $koneksi->prepare($sql_update)) {
            $stmt->bind_param("ssssssssssi", 
                $nama_perusahaan, 
                $alamat, 
                $telepon, 
                $email, 
                $website, 
                $new_foto_filename, 
                $new_foto2_filename, 
                $deskripsi_singkat, 
                $visi, 
                $misi, 
                $id_profile
            );

            if ($stmt->execute()) {
                $message = "Profil perusahaan berhasil diperbarui.";
                $message_type = "success";
                // Re-fetch data untuk menampilkan yang terbaru di form
                $result = $koneksi->query($sql_select);
                if ($result && $result->num_rows > 0) {
                    $profile = $result->fetch_assoc();
                }
            } else {
                $message = "Gagal memperbarui profil perusahaan: " . $stmt->error;
                $message_type = "danger";
            }
            $stmt->close();
        } else {
            $message = "Gagal menyiapkan statement update: " . $koneksi->error;
            $message_type = "danger";
        }
    }
}

$koneksi->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?> - Admin Buku Tamu</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }
        .navbar-admin { background-color: #0E5CAD; color: white; }
        .navbar-admin .navbar-brand, .navbar-admin .nav-link { color: white; }
        .navbar-admin .nav-link:hover { color: #79F1A4; }
        .sidebar { height: 100vh; position: fixed; top: 0; left: 0; width: 250px; padding-top: 56px; background-color: #343a40; color: white; z-index: 100; }
        .sidebar .nav-link { color: #adb5bd; padding: 0.75rem 1.25rem; display: flex; align-items: center; }
        .sidebar .nav-link i { margin-right: 0.75rem; font-size: 1.1rem; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { color: white; background-color: #495057; }
        .sidebar .sidebar-header { padding: 1.25rem; text-align: center; border-bottom: 1px solid #495057; }
        .main-content { margin-left: 250px; padding-top: 70px; padding-left: 1.5rem; padding-right: 1.5rem; padding-bottom: 1.5rem;}
        .card-header-custom { background-color: #0E5CAD; color: white; }
        .current-image { max-width: 150px; max-height: 150px; margin-top: 10px; border-radius: 0.25rem; border: 1px solid #dee2e6; }
        @media (max-width: 767.98px) {
            .sidebar { width: 100%; height: auto; position: relative; padding-top: 0; }
            .main-content { margin-left: 0; padding-top: 1rem; }
        }
    </style>
</head>
<body>
    <?php include_once '_partials/navbar.php'; // Membuat navbar admin terpisah ?>
    <?php include_once '_partials/sidebar.php'; // Membuat sidebar admin terpisah ?>

    <main class="main-content">
        <div class="container-fluid">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2"><?php echo htmlspecialchars($page_title); ?></h1>
            </div>

            <?php if ($message): ?>
            <div class="alert alert-<?php echo $message_type === 'success' ? 'success' : 'danger'; ?> alert-dismissible fade show" role="alert">
                <?php echo htmlspecialchars($message); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>

            <?php if ($profile): ?>
            <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" enctype="multipart/form-data">
                <div class="card">
                    <div class="card-header card-header-custom">
                        <h5 class="mb-0">Detail Perusahaan</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="nama_perusahaan" class="form-label">Nama Perusahaan/Instansi <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="nama_perusahaan" name="nama_perusahaan" value="<?php echo htmlspecialchars($profile['nama_perusahaan']); ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($profile['email'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="alamat" class="form-label">Alamat</label>
                            <textarea class="form-control" id="alamat" name="alamat" rows="2"><?php echo htmlspecialchars($profile['alamat'] ?? ''); ?></textarea>
                        </div>
                        <div class="row">
                             <div class="col-md-6 mb-3">
                                <label for="telepon" class="form-label">Telepon</label>
                                <input type="text" class="form-control" id="telepon" name="telepon" value="<?php echo htmlspecialchars($profile['telepon'] ?? ''); ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="website" class="form-label">Website</label>
                                <input type="url" class="form-control" id="website" name="website" value="<?php echo htmlspecialchars($profile['website'] ?? ''); ?>" placeholder="https://example.com">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="deskripsi_singkat" class="form-label">Deskripsi Singkat (untuk halaman utama)</label>
                            <textarea class="form-control" id="deskripsi_singkat" name="deskripsi_singkat" rows="2"><?php echo htmlspecialchars($profile['deskripsi_singkat'] ?? ''); ?></textarea>
                        </div>
                         <div class="mb-3">
                            <label for="visi" class="form-label">Visi</label>
                            <textarea class="form-control" id="visi" name="visi" rows="3"><?php echo htmlspecialchars($profile['visi'] ?? ''); ?></textarea>
                        </div>
                        <div class="mb-3">
                            <label for="misi" class="form-label">Misi</label>
                            <textarea class="form-control" id="misi" name="misi" rows="3"><?php echo htmlspecialchars($profile['misi'] ?? ''); ?></textarea>
                        </div>

                        <hr class="my-4">
                        <h5 class="mb-3">Gambar</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="foto" class="form-label">Logo Perusahaan (Max 2MB)</label>
                                <input class="form-control" type="file" id="foto" name="foto" accept="image/*">
                                <?php if (!empty($profile['foto'])): ?>
                                    <div class="mt-2">
                                        <small>Logo Saat Ini:</small><br>
                                        <img src="images/<?php echo htmlspecialchars($profile['foto']); ?>" alt="Logo Saat Ini" class="current-image">
                                    </div>
                                <?php endif; ?>
                                <small class="form-text text-muted">Kosongkan jika tidak ingin mengubah logo.</small>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="foto2" class="form-label">Gambar Ilustrasi (Max 2MB)</label>
                                <input class="form-control" type="file" id="foto2" name="foto2" accept="image/*">
                                <?php if (!empty($profile['foto2'])): ?>
                                    <div class="mt-2">
                                        <small>Ilustrasi Saat Ini:</small><br>
                                        <img src="images/<?php echo htmlspecialchars($profile['foto2']); ?>" alt="Ilustrasi Saat Ini" class="current-image">
                                    </div>
                                <?php endif; ?>
                                <small class="form-text text-muted">Kosongkan jika tidak ingin mengubah ilustrasi.</small>
                            </div>
                        </div>

                    </div>
                    <div class="card-footer text-end">
                        <button type="submit" class="btn btn-primary"><i class="bi bi-save-fill"></i> Simpan Perubahan</button>
                    </div>
                </div>
            </form>
            <?php else: ?>
                <?php if(empty($message)) : // Hanya tampilkan jika belum ada pesan error spesifik dari fetch ?>
                <div class="alert alert-warning" role="alert">
                    Data profil perusahaan belum ada atau tidak dapat dimuat. Silakan pastikan data awal sudah dimasukkan ke tabel <code>tb_profile</code>.
                </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>