<?php
// File: isi.php
// (session_start() sudah ada di index.php)

// Pastikan variabel $koneksi sudah ada dari index.php
if (!isset($koneksi) || !($koneksi instanceof mysqli)) {
    $koneksiPath = __DIR__ . DIRECTORY_SEPARATOR . "koneksi" . DIRECTORY_SEPARATOR . "koneksi.php";
    if (file_exists($koneksiPath)) {
        require_once $koneksiPath;
    } else {
        $_SESSION['gagal'] = "Koneksi database tidak tersedia untuk memproses formulir.";
    }
}

// === AWAL BLOK LOGIKA FORM REGISTRASI TAMU (SUDAH ADA DARI LANGKAH SEBELUMNYA) ===
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['nama_tamu'])) { // Tambahkan isset($_POST['nama_tamu']) untuk membedakan form
    // ... (kode proses form registrasi tamu yang sudah Anda buat sebelumnya) ...
    // Pastikan Anda memiliki cara untuk membedakan submit form ini
    // dari form kepuasan, misal dengan mengecek keberadaan field unik
    // seperti 'nama_tamu' atau menambahkan input hidden dengan nama form.
    // Untuk sekarang, kita anggap jika ada 'nama_tamu' di POST, itu adalah form registrasi.

    // Ambil dan sanitasi data dari form
    $nama_tamu = htmlspecialchars(trim($_POST['nama_tamu'] ?? ''));
    // ... (sisa field registrasi) ...
    $asal_instansi = htmlspecialchars(trim($_POST['asal_instansi'] ?? ''));
    $jabatan = htmlspecialchars(trim($_POST['jabatan'] ?? ''));
    $no_telepon = htmlspecialchars(trim($_POST['no_telepon'] ?? ''));
    $email_tamu = htmlspecialchars(trim($_POST['email_tamu'] ?? ''));
    $bertemu_dengan = htmlspecialchars(trim($_POST['bertemu_dengan'] ?? ''));
    $keperluan = htmlspecialchars(trim($_POST['keperluan'] ?? ''));
    $catatan_tambahan = htmlspecialchars(trim($_POST['catatan_tambahan'] ?? ''));

    $tanggal_kunjungan = date("Y-m-d");
    $waktu_masuk = date("H:i:s");

    if (empty($nama_tamu) || empty($bertemu_dengan) || empty($keperluan)) {
        $_SESSION['gagal'] = "Kolom Nama Tamu, Bertemu Dengan, dan Keperluan wajib diisi.";
    } else {
        $sql_tamu = "INSERT INTO tb_tamu (tanggal_kunjungan, waktu_masuk, nama_tamu, asal_instansi, jabatan, no_telepon, email_tamu, bertemu_dengan, keperluan, catatan_tambahan) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        if ($stmt_tamu = $koneksi->prepare($sql_tamu)) {
            $stmt_tamu->bind_param("ssssssssss",
                $tanggal_kunjungan,
                $waktu_masuk,
                $nama_tamu,
                $asal_instansi,
                $jabatan,
                $no_telepon,
                $email_tamu,
                $bertemu_dengan,
                $keperluan,
                $catatan_tambahan
            );
            if ($stmt_tamu->execute()) {
                $_SESSION['sukses'] = "Registrasi kunjungan berhasil disimpan. Terima kasih!";
            } else {
                $_SESSION['gagal'] = "Gagal menyimpan data kunjungan: " . $stmt_tamu->error;
                error_log("Error insert tb_tamu: " . $stmt_tamu->error);
            }
            $stmt_tamu->close();
        } else {
            $_SESSION['gagal'] = "Gagal menyiapkan statement SQL tamu: " . $koneksi->error;
            error_log("Error prepare statement tb_tamu: " . $koneksi->error);
        }
    }
}
// === AKHIR BLOK LOGIKA FORM REGISTRASI TAMU ===


// === AWAL BLOK LOGIKA FORM KEPUASAN ===
// Kita bedakan dengan mengecek salah satu field unik dari form kepuasan, misal 'nilai_pelayanan'
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit_kepuasan'])) { // Menggunakan input hidden 'submit_kepuasan'
    if (isset($koneksi) && $koneksi instanceof mysqli) {
        $nama_responden = htmlspecialchars(trim($_POST['nama_responden'] ?? '')); // Bisa diisi atau tidak
        // Ambil id_tamu terakhir jika ada (misalnya, jika survei diisi setelah registrasi)
        // Ini contoh sederhana, implementasi sebenarnya mungkin lebih kompleks
        // $id_tamu_fk = isset($_SESSION['last_guest_id']) ? $_SESSION['last_guest_id'] : null;
        // Untuk sekarang, kita biarkan id_tamu_fk tidak diisi otomatis dari session, bisa diisi manual jika ada fieldnya
        $id_tamu_fk_input = filter_input(INPUT_POST, 'id_tamu_fk', FILTER_VALIDATE_INT);
        $id_tamu_fk = $id_tamu_fk_input ?: null;


        $nilai_pelayanan = filter_input(INPUT_POST, 'nilai_pelayanan', FILTER_VALIDATE_INT, ["options" => ["min_range"=>1, "max_range"=>5]]);
        $nilai_fasilitas = filter_input(INPUT_POST, 'nilai_fasilitas', FILTER_VALIDATE_INT, ["options" => ["min_range"=>1, "max_range"=>5]]);
        $nilai_keramahan = filter_input(INPUT_POST, 'nilai_keramahan', FILTER_VALIDATE_INT, ["options" => ["min_range"=>1, "max_range"=>5]]);
        $nilai_kecepatan = filter_input(INPUT_POST, 'nilai_kecepatan', FILTER_VALIDATE_INT, ["options" => ["min_range"=>1, "max_range"=>5]]);
        $saran_masukan = htmlspecialchars(trim($_POST['saran_masukan'] ?? ''));

        $tanggal_survei = date("Y-m-d");
        $waktu_survei = date("H:i:s");

        // Validasi
        if ($nilai_pelayanan === false || $nilai_fasilitas === false || $nilai_keramahan === false || $nilai_kecepatan === false) {
            $_SESSION['gagal'] = "Semua pertanyaan penilaian wajib diisi dengan benar (skala 1-5).";
        } else {
            $sql_kepuasan = "INSERT INTO tb_kepuasan (id_tamu_fk, nama_responden, tanggal_survei, waktu_survei, nilai_pelayanan, nilai_fasilitas, nilai_keramahan, nilai_kecepatan, saran_masukan) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

            if ($stmt_kepuasan = $koneksi->prepare($sql_kepuasan)) {
                // i untuk integer, s untuk string
                $stmt_kepuasan->bind_param("isssiiiis",
                    $id_tamu_fk, // Jika tidak ada, akan jadi NULL
                    $nama_responden,
                    $tanggal_survei,
                    $waktu_survei,
                    $nilai_pelayanan,
                    $nilai_fasilitas,
                    $nilai_keramahan,
                    $nilai_kecepatan,
                    $saran_masukan
                );

                if ($stmt_kepuasan->execute()) {
                    $_SESSION['sukses'] = "Survei kepuasan Anda berhasil dikirim. Terima kasih atas partisipasinya!";
                    // header("Location: index.php?page=spk"); // Redirect untuk clear form
                    // exit();
                } else {
                    $_SESSION['gagal'] = "Gagal menyimpan data survei: " . $stmt_kepuasan->error;
                    error_log("Error insert tb_kepuasan: " . $stmt_kepuasan->error);
                }
                $stmt_kepuasan->close();
            } else {
                $_SESSION['gagal'] = "Gagal menyiapkan statement SQL survei: " . $koneksi->error;
                error_log("Error prepare statement tb_kepuasan: " . $koneksi->error);
            }
        }
    } else {
        $_SESSION['gagal'] = "Koneksi database tidak tersedia. Tidak dapat menyimpan data survei.";
    }
    // Redirect setelah POST untuk mencegah resubmit dan membersihkan URL
    // header("Location: index.php?page=spk");
    // exit;
}
// === AKHIR BLOK LOGIKA FORM KEPUASAN ===


// === AWAL BLOK TAMPILAN KONTEN (HTML) ===
// Logika untuk Form Indeks Kepuasan (akan kita isi nanti)
if (isset($_GET['page']) && $_GET['page'] === 'spk') {
?>
    <form id="formKepuasan" method="POST" action="index.php?page=spk">
        <input type="hidden" name="submit_kepuasan" value="1"> <div class="mb-3">
            <label for="nama_responden" class="form-label"><i class="bi bi-person-check-fill"></i> Nama Anda (Opsional)</label>
            <input type="text" class="form-control" id="nama_responden" name="nama_responden" placeholder="Boleh dikosongkan jika ingin anonim">
        </div>

        <p class="fw-bold mb-1">Berikan penilaian Anda (1 = Sangat Buruk, 5 = Sangat Baik):</p>

        <div class="card mb-3 shadow-sm">
            <div class="card-body">
                <label class="form-label d-block"><i class="bi bi-headset"></i> Kualitas Pelayanan:</label>
                <?php for ($i = 1; $i <= 5; $i++): ?>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="nilai_pelayanan" id="pelayanan_<?php echo $i; ?>" value="<?php echo $i; ?>" required>
                    <label class="form-check-label" for="pelayanan_<?php echo $i; ?>"><?php echo $i; ?></label>
                </div>
                <?php endfor; ?>
            </div>
        </div>

        <div class="card mb-3 shadow-sm">
            <div class="card-body">
                <label class="form-label d-block"><i class="bi bi-building-gear"></i> Fasilitas yang Tersedia:</label>
                <?php for ($i = 1; $i <= 5; $i++): ?>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="nilai_fasilitas" id="fasilitas_<?php echo $i; ?>" value="<?php echo $i; ?>" required>
                    <label class="form-check-label" for="fasilitas_<?php echo $i; ?>"><?php echo $i; ?></label>
                </div>
                <?php endfor; ?>
            </div>
        </div>

        <div class="card mb-3 shadow-sm">
            <div class="card-body">
                <label class="form-label d-block"><i class="bi bi-emoji-smile-fill"></i> Keramahan Staf:</label>
                <?php for ($i = 1; $i <= 5; $i++): ?>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="nilai_keramahan" id="keramahan_<?php echo $i; ?>" value="<?php echo $i; ?>" required>
                    <label class="form-check-label" for="keramahan_<?php echo $i; ?>"><?php echo $i; ?></label>
                </div>
                <?php endfor; ?>
            </div>
        </div>

        <div class="card mb-4 shadow-sm">
            <div class="card-body">
                <label class="form-label d-block"><i class="bi bi-clock-history"></i> Kecepatan Layanan:</label>
                <?php for ($i = 1; $i <= 5; $i++): ?>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="nilai_kecepatan" id="kecepatan_<?php echo $i; ?>" value="<?php echo $i; ?>" required>
                    <label class="form-check-label" for="kecepatan_<?php echo $i; ?>"><?php echo $i; ?></label>
                </div>
                <?php endfor; ?>
            </div>
        </div>


        <div class="mb-4">
            <label for="saran_masukan" class="form-label"><i class="bi bi-chat-quote-fill"></i> Saran dan Masukan (Opsional):</label>
            <textarea class="form-control" id="saran_masukan" name="saran_masukan" rows="3" placeholder="Sampaikan saran atau masukan Anda untuk perbaikan layanan kami"></textarea>
        </div>

        <div class="d-grid">
            <button type="submit" class="btn btn-submit-modern">
                <i class="bi bi-send-check-fill me-2"></i>Kirim Survei
            </button>
        </div>
        <p class="mt-3 text-center">
            <a href="index.php" class="text-decoration-none"><i class="bi bi-arrow-left-circle"></i> Kembali ke Registrasi Tamu</a>
        </p>
    </form>

<?php
} else {
// Tampilkan Form Registrasi Tamu jika bukan halaman SPK (KODE INI SUDAH ADA DARI LANGKAH SEBELUMNYA)
?>
    <form id="formRegistrasiTamu" method="POST" action="index.php">
        <div class="row g-3 mb-4">
            <div class="col-md-6">
                <label for="nama_tamu" class="form-label"><i class="bi bi-person-fill"></i> Nama Lengkap Tamu <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nama_tamu" name="nama_tamu" placeholder="Masukkan nama lengkap Anda" required>
            </div>
            <div class="col-md-6">
                <label for="asal_instansi" class="form-label"><i class="bi bi-building"></i> Asal Instansi/Perusahaan</label>
                <input type="text" class="form-control" id="asal_instansi" name="asal_instansi" placeholder="Contoh: PT Maju Jaya atau Pribadi">
            </div>
        </div>

        <div class="row g-3 mb-4">
            <div class="col-md-6">
                <label for="jabatan" class="form-label"><i class="bi bi-person-badge"></i> Jabatan</label>
                <input type="text" class="form-control" id="jabatan" name="jabatan" placeholder="Contoh: Direktur, Staf, Umum">
            </div>
            <div class="col-md-6">
                <label for="no_telepon" class="form-label"><i class="bi bi-telephone-fill"></i> Nomor Telepon</label>
                <input type="tel" class="form-control" id="no_telepon" name="no_telepon" placeholder="Contoh: 081234567890">
            </div>
        </div>

        <div class="mb-4">
            <label for="email_tamu" class="form-label"><i class="bi bi-envelope-fill"></i> Alamat Email</label>
            <input type="email" class="form-control" id="email_tamu" name="email_tamu" placeholder="Contoh: nama@example.com">
        </div>

        <div class="mb-4">
            <label for="bertemu_dengan" class="form-label"><i class="bi bi-people-fill"></i> Bertemu Dengan Siapa/Bagian Apa <span class="text-danger">*</span></label>
            <input type="text" class="form-control" id="bertemu_dengan" name="bertemu_dengan" placeholder="Nama orang atau bagian yang dituju" required>
        </div>

        <div class="mb-4">
            <label for="keperluan" class="form-label"><i class="bi bi-chat-left-dots-fill"></i> Keperluan Kunjungan <span class="text-danger">*</span></label>
            <textarea class="form-control" id="keperluan" name="keperluan" rows="3" placeholder="Jelaskan tujuan kunjungan Anda" required></textarea>
        </div>

        <div class="mb-4">
            <label for="catatan_tambahan" class="form-label"><i class="bi bi-journal-text"></i> Catatan Tambahan (Opsional)</label>
            <textarea class="form-control" id="catatan_tambahan" name="catatan_tambahan" rows="2" placeholder="Informasi tambahan jika ada"></textarea>
        </div>
        <div class="d-grid">
            <button type="submit" class="btn btn-submit-modern">
                <i class="bi bi-check-circle-fill me-2"></i>Kirim Registrasi
            </button>
        </div>
    </form>
<?php
} // Akhir dari else (untuk tampilan form registrasi)
// === AKHIR BLOK TAMPILAN KONTEN (HTML) ===
?>