<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends MY_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->require_login();

		$this->load->model('Customer_model', 'customers');
		$this->load->model('Service_model', 'services');
		$this->load->model('Order_model', 'orders');
	}

	public function index()
	{
		$data = array(
			'title' => 'Dashboard',
			'count_customers' => (int) $this->db->count_all('customers'),
			'count_services' => (int) $this->db->count_all('services'),
			'count_orders' => (int) $this->db->count_all('orders'),
			'latest_orders' => $this->db
				->select('o.*, c.name as customer_name, s.name as service_name')
				->from('orders o')
				->join('customers c', 'c.id=o.customer_id')
				->join('services s', 's.id=o.service_id')
				->order_by('o.id', 'DESC')
				->limit(10)
				->get()
				->result(),
		);

		$this->render('dashboard/index', $data);
	}
}

