<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Orders extends MY_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->require_login();
		$this->load->model('Order_model', 'orders');
		$this->load->model('Customer_model', 'customers');
		$this->load->model('Service_model', 'services');
		$this->load->model('Payment_model', 'payments');
	}

	public function index()
	{
		$this->render('orders/index', array(
			'title' => 'Order Laundry',
			'rows' => $this->orders->all_with_relations(),
		));
	}

	public function create()
	{
		$customers = $this->customers->all();
		$services = $this->services->all();

		$this->form_validation->set_rules('customer_id', 'Pelanggan', 'required|integer');
		$this->form_validation->set_rules('service_id', 'Layanan', 'required|integer');
		$this->form_validation->set_rules('qty', 'Qty', 'required|numeric|greater_than[0]');
		$this->form_validation->set_rules('pickup_date', 'Tanggal masuk', 'trim');
		$this->form_validation->set_rules('due_date', 'Estimasi selesai', 'trim');
		$this->form_validation->set_rules('status', 'Status', 'required|in_list[baru,proses,selesai,diambil,batal]');
		$this->form_validation->set_rules('notes', 'Catatan', 'trim|max_length[255]');

		if ($this->input->method(TRUE) === 'POST' && $this->form_validation->run()) {
			$service = $this->services->find((int) $this->input->post('service_id', TRUE));
			if (!$service) {
				show_error('Layanan tidak ditemukan', 400);
			}

			$qty = (float) $this->input->post('qty', TRUE);
			$total = $qty * (float) $service->price;

			$order_id = $this->orders->create(array(
				'code' => $this->orders->generate_code(),
				'customer_id' => (int) $this->input->post('customer_id', TRUE),
				'service_id' => (int) $this->input->post('service_id', TRUE),
				'qty' => $qty,
				'pickup_date' => $this->input->post('pickup_date', TRUE) ?: null,
				'due_date' => $this->input->post('due_date', TRUE) ?: null,
				'status' => $this->input->post('status', TRUE),
				'notes' => $this->input->post('notes', TRUE),
				'total' => $total,
				'paid_amount' => 0,
			));

			$this->session->set_flashdata('success', 'Order berhasil dibuat.');
			redirect('orders/show/' . $order_id);
		}

		$this->render('orders/form', array(
			'title' => 'Tambah Order',
			'mode' => 'create',
			'row' => null,
			'customers' => $customers,
			'services' => $services,
		));
	}

	public function edit($id)
	{
		$row = $this->orders->find_with_relations($id);
		if (!$row) {
			show_404();
		}

		$customers = $this->customers->all();
		$services = $this->services->all();

		$this->form_validation->set_rules('customer_id', 'Pelanggan', 'required|integer');
		$this->form_validation->set_rules('service_id', 'Layanan', 'required|integer');
		$this->form_validation->set_rules('qty', 'Qty', 'required|numeric|greater_than[0]');
		$this->form_validation->set_rules('pickup_date', 'Tanggal masuk', 'trim');
		$this->form_validation->set_rules('due_date', 'Estimasi selesai', 'trim');
		$this->form_validation->set_rules('status', 'Status', 'required|in_list[baru,proses,selesai,diambil,batal]');
		$this->form_validation->set_rules('notes', 'Catatan', 'trim|max_length[255]');

		if ($this->input->method(TRUE) === 'POST' && $this->form_validation->run()) {
			$service = $this->services->find((int) $this->input->post('service_id', TRUE));
			if (!$service) {
				show_error('Layanan tidak ditemukan', 400);
			}

			$qty = (float) $this->input->post('qty', TRUE);
			$total = $qty * (float) $service->price;

			$this->orders->update($id, array(
				'customer_id' => (int) $this->input->post('customer_id', TRUE),
				'service_id' => (int) $this->input->post('service_id', TRUE),
				'qty' => $qty,
				'pickup_date' => $this->input->post('pickup_date', TRUE) ?: null,
				'due_date' => $this->input->post('due_date', TRUE) ?: null,
				'status' => $this->input->post('status', TRUE),
				'notes' => $this->input->post('notes', TRUE),
				'total' => $total,
			));

			$this->session->set_flashdata('success', 'Order berhasil diubah.');
			redirect('orders/show/' . $id);
		}

		$this->render('orders/form', array(
			'title' => 'Edit Order',
			'mode' => 'edit',
			'row' => $row,
			'customers' => $customers,
			'services' => $services,
		));
	}

	public function show($id)
	{
		// Ensure paid_amount is up to date
		$this->orders->refresh_paid_amount($id);
		
		$row = $this->orders->find_with_relations($id);
		if (!$row) {
			show_404();
		}

		$payments = $this->payments->for_order($id);
		$remaining = max(0, (float) $row->total - (float) $row->paid_amount);

		$this->render('orders/show', array(
			'title' => 'Detail Order',
			'row' => $row,
			'payments' => $payments,
			'remaining' => $remaining,
		));
	}

	public function delete($id)
	{
		if ($this->input->method(TRUE) !== 'POST') {
			show_error('Metode tidak diizinkan', 405);
		}
		$this->orders->delete($id);
		$this->session->set_flashdata('success', 'Order berhasil dihapus.');
		redirect('orders');
	}
}

