<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pages extends MY_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->require_login();
		$this->load->model('Page_model', 'pages');
	}

	public function terms()
	{
		$slug = 'terms';
		if (!$this->db->table_exists('pages')) {
			show_error('Tabel `pages` belum ada. Import `database/update_pages_terms.sql` ke database `loundri` terlebih dahulu.', 500);
		}

		$page = $this->pages->find_by_slug($slug);

		$this->form_validation->set_rules('title', 'Judul', 'trim|required|max_length[150]');
		$this->form_validation->set_rules('content_html', 'Konten', 'trim|required');

		if ($this->input->method(TRUE) === 'POST' && $this->form_validation->run()) {
			$title = $this->input->post('title', TRUE);
			$content = (string) $this->input->post('content_html', FALSE);

			$content = $this->security->xss_clean($content);

			$this->pages->upsert($slug, array(
				'title' => $title,
				'content_html' => $content,
			));

			$this->session->set_flashdata('success', 'Halaman Syarat & Ketentuan berhasil disimpan.');
			redirect('pages/terms');
		}

		$this->render('pages/terms_form', array(
			'title' => 'Edit Syarat & Ketentuan',
			'page' => $page,
			'slug' => $slug,
		));
	}
}
