<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class MY_Controller extends CI_Controller
{
	protected $current_user = null;

	public function __construct()
	{
		parent::__construct();
		$this->current_user = $this->session->userdata('user');
	}

	protected function require_login()
	{
		if (!$this->current_user) {
			$this->session->set_flashdata('error', 'Silakan login terlebih dahulu.');
			redirect('login');
		}
	}

	protected function render($view, $data = array())
	{
		$data['current_user'] = $this->current_user;
		$this->load->view('layouts/header', $data);
		$this->load->view('layouts/sidebar', $data);
		$this->load->view('layouts/topbar', $data);
		$this->load->view($view, $data);
		$this->load->view('layouts/footer', $data);
	}
}

