<?php
defined('BASEPATH') OR exit('No direct script access allowed');

function rupiah($amount)
{
	$amount = (float) $amount;
	return 'Rp ' . number_format($amount, 0, ',', '.');
}

function e($str)
{
	return html_escape($str);
}

function order_status_label($status)
{
	$map = array(
		'baru' => array('Baru', 'secondary'),
		'proses' => array('Diproses', 'warning'),
		'selesai' => array('Selesai', 'success'),
		'diambil' => array('Diambil', 'primary'),
		'batal' => array('Batal', 'danger'),
		'dikonfirmasi' => array('Dikonfirmasi', 'info'),
		'dipickup' => array('Dipickup', 'warning'),
	);

	if (!isset($map[$status])) {
		return '<span class="badge bg-dark">Unknown</span>';
	}

	list($text, $color) = $map[$status];
	return '<span class="badge bg-' . $color . '">' . $text . '</span>';
}
