<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Outlet_model extends CI_Model
{
	protected $table = 'outlets';

	public function all($only_active = FALSE)
	{
		if ($only_active) {
			$this->db->where('is_active', 1);
		}
		return $this->db->order_by('id', 'DESC')->get($this->table)->result();
	}

	public function find($id)
	{
		return $this->db->get_where($this->table, array('id' => (int) $id))->row();
	}

	public function create($data)
	{
		$data['created_at'] = date('Y-m-d H:i:s');
		$this->db->insert($this->table, $data);
		return $this->db->insert_id();
	}

	public function update($id, $data)
	{
		$this->db->where('id', (int) $id)->update($this->table, $data);
		return $this->db->affected_rows() >= 0;
	}

	public function delete($id)
	{
		$this->db->where('id', (int) $id)->delete($this->table);
		return $this->db->affected_rows() > 0;
	}
}

