<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Page_model extends CI_Model
{
	protected $table = 'pages';

	public function find_by_slug($slug)
	{
		return $this->db->get_where($this->table, array('slug' => $slug))->row();
	}

	public function upsert($slug, $data)
	{
		$existing = $this->find_by_slug($slug);
		$now = date('Y-m-d H:i:s');

		if ($existing) {
			$data['updated_at'] = $now;
			$this->db->where('id', (int) $existing->id)->update($this->table, $data);
			return (int) $existing->id;
		}

		$data['slug'] = $slug;
		$data['created_at'] = $now;
		$data['updated_at'] = $now;
		$this->db->insert($this->table, $data);
		return (int) $this->db->insert_id();
	}
}

