<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payment_model extends CI_Model
{
	protected $table = 'payments';

	public function for_order($order_id)
	{
		return $this->db
			->order_by('id', 'DESC')
			->get_where($this->table, array('order_id' => (int) $order_id))
			->result();
	}

	public function create($data)
	{
		$data['paid_at'] = isset($data['paid_at']) && $data['paid_at'] ? $data['paid_at'] : date('Y-m-d H:i:s');
		$data['created_at'] = date('Y-m-d H:i:s');
		$this->db->insert($this->table, $data);
		return $this->db->insert_id();
	}

	public function find($id)
	{
		return $this->db->get_where($this->table, array('id' => (int) $id))->row();
	}

	public function update($id, $data)
	{
		$this->db->where('id', (int) $id)->update($this->table, $data);
		return $this->db->affected_rows() >= 0;
	}
}

