<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!doctype html>
<html lang="id">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Login - Loundri</title>
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Baloo+2:wght@700;800&family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
	<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
	<link href="<?php echo base_url('assets/public.css'); ?>" rel="stylesheet">
	<style>
		body{
			background:
				radial-gradient(900px 450px at 10% 10%, rgba(34,197,94,.12), transparent 60%),
				radial-gradient(900px 450px at 90% 0%, rgba(14,165,163,.14), transparent 55%),
				linear-gradient(180deg, #f8fbff 0%, #f4fbfa 100%);
			min-height: 100vh;
		}
		.auth-card{ border: 1px solid rgba(0,0,0,.06); border-radius: 18px; }
		.auth-brand{
			font-family: "Baloo 2", Inter, system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
			font-weight: 800;
		}
	</style>
</head>
<body>
	<div class="container py-5">
		<div class="row justify-content-center">
			<div class="col-md-6 col-lg-5 col-xl-4">
				<div class="auth-card bg-white shadow-soft">
					<div class="card-body p-4 p-lg-5">
						<div class="d-flex align-items-center gap-3 mb-3">
							<div class="brand-mark" aria-hidden="true">
								<i class="bi bi-droplet-half" style="color: var(--brand);"></i>
							</div>
							<div>
								<div class="auth-brand fs-3 mb-0"><span class="brand-text">Loundri</span> Admin</div>
								<div class="text-muted small">Masuk untuk mengelola order & pembayaran</div>
							</div>
						</div>

						<?php if ($this->session->flashdata('error')): ?>
							<div class="alert alert-danger"><?php echo e($this->session->flashdata('error')); ?></div>
						<?php endif; ?>
						<?php if (validation_errors()): ?>
							<div class="alert alert-danger"><?php echo validation_errors(); ?></div>
						<?php endif; ?>

						<form method="post" action="<?php echo site_url('login'); ?>">
							<div class="mb-3">
								<label class="form-label">Username</label>
								<input type="text" name="username" class="form-control" value="<?php echo set_value('username'); ?>" required>
							</div>
							<div class="mb-3">
								<label class="form-label">Password</label>
								<input type="password" name="password" class="form-control" required>
							</div>
							<button class="btn btn-brand text-white w-100" type="submit"><i class="bi bi-box-arrow-in-right"></i> Masuk</button>
						</form>
						<div class="d-flex justify-content-between small text-muted mt-3">
							<a class="text-muted" href="<?php echo site_url('beranda'); ?>">&larr; Kembali ke beranda</a>
							<a class="text-muted" href="<?php echo site_url('cek-status'); ?>">Cek status</a>
						</div>
					</div>
				</div>
				<div class="text-center small text-muted mt-3">Default: <span class="mono">admin</span> / <span class="mono">admin123</span></div>
			</div>
		</div>
	</div>
</body>
</html>
