<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
	<div class="text-muted">Kelola data pelanggan</div>
	<a href="<?php echo site_url('customers/create'); ?>" class="btn btn-primary">Tambah</a>
</div>

<div class="card">
	<div class="table-responsive">
		<table class="table table-striped mb-0">
			<thead>
				<tr>
					<th>Nama</th>
					<th>No. HP</th>
					<th>Alamat</th>
					<th></th>
				</tr>
			</thead>
			<tbody>
				<?php if (!$rows): ?>
					<tr><td colspan="4" class="text-center text-muted py-4">Belum ada pelanggan</td></tr>
				<?php endif; ?>
				<?php foreach ($rows as $r): ?>
					<tr>
						<td><?php echo e($r->name); ?></td>
						<td><?php echo e($r->phone); ?></td>
						<td><?php echo e($r->address); ?></td>
						<td class="text-end">
							<a class="btn btn-sm btn-outline-secondary" href="<?php echo site_url('customers/edit/' . $r->id); ?>">Edit</a>
							<form method="post" action="<?php echo site_url('customers/delete/' . $r->id); ?>" class="d-inline" onsubmit="return confirm('Hapus pelanggan ini?')">
								<button type="submit" class="btn btn-sm btn-outline-danger">Hapus</button>
							</form>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	</div>
</div>

