<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="row g-3 mb-4">
	<div class="col-md-4">
		<div class="card">
			<div class="card-body">
				<div class="text-muted small">Pelanggan</div>
				<div class="fs-3 fw-semibold"><?php echo (int) $count_customers; ?></div>
			</div>
		</div>
	</div>
	<div class="col-md-4">
		<div class="card">
			<div class="card-body">
				<div class="text-muted small">Layanan</div>
				<div class="fs-3 fw-semibold"><?php echo (int) $count_services; ?></div>
			</div>
		</div>
	</div>
	<div class="col-md-4">
		<div class="card">
			<div class="card-body">
				<div class="text-muted small">Order</div>
				<div class="fs-3 fw-semibold"><?php echo (int) $count_orders; ?></div>
			</div>
		</div>
	</div>
</div>

<div class="card">
	<div class="card-header d-flex justify-content-between align-items-center">
		<div class="fw-semibold">Order Terbaru</div>
		<a href="<?php echo site_url('orders/create'); ?>" class="btn btn-sm btn-primary">Tambah Order</a>
	</div>
	<div class="table-responsive">
		<table class="table table-striped mb-0">
			<thead>
				<tr>
					<th>Kode</th>
					<th>Pelanggan</th>
					<th>Layanan</th>
					<th>Status</th>
					<th>Total</th>
					<th></th>
				</tr>
			</thead>
			<tbody>
				<?php if (!$latest_orders): ?>
					<tr><td colspan="6" class="text-center text-muted py-4">Belum ada order</td></tr>
				<?php endif; ?>
				<?php foreach ($latest_orders as $o): ?>
					<tr>
						<td><?php echo e($o->code); ?></td>
						<td><?php echo e($o->customer_name); ?></td>
						<td><?php echo e($o->service_name); ?></td>
						<td><?php echo order_status_label($o->status); ?></td>
						<td><?php echo rupiah($o->total); ?></td>
						<td class="text-end">
							<a class="btn btn-sm btn-outline-secondary" href="<?php echo site_url('orders/show/' . $o->id); ?>">Detail</a>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	</div>
</div>

