<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php
	$uri = $this->uri->segment(1);
	$dashboard_active = ($uri === '' || $uri === 'dashboard' || $uri === 'admin');
?>
<div class="offcanvas-lg offcanvas-start admin-sidebar" tabindex="-1" id="adminSidebar" aria-labelledby="adminSidebarLabel">
	<div class="offcanvas-header d-lg-none">
		<h5 class="offcanvas-title" id="adminSidebarLabel">Loundri</h5>
		<button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas" aria-label="Close"></button>
	</div>

	<div class="offcanvas-body p-0 d-flex flex-column h-100">
		<div class="admin-brand">
			<div class="mark" aria-hidden="true">
				<i class="bi bi-droplet-half"></i>
			</div>
			<div class="min-w-0">
				<div class="title">Loundri</div>
				<div class="subtitle">Admin Panel</div>
			</div>
		</div>

		<nav class="nav flex-column admin-nav">
			<a class="nav-link <?php echo $dashboard_active ? 'active' : ''; ?>" href="<?php echo site_url('admin'); ?>">
				<i class="bi bi-speedometer2"></i> Dashboard
			</a>
			<a class="nav-link <?php echo $uri === 'outlets' ? 'active' : ''; ?>" href="<?php echo site_url('outlets'); ?>">
				<i class="bi bi-geo-alt"></i> Outlet
			</a>
			<a class="nav-link <?php echo $uri === 'pages' ? 'active' : ''; ?>" href="<?php echo site_url('pages/terms'); ?>">
				<i class="bi bi-file-earmark-text"></i> Syarat
			</a>
			<a class="nav-link <?php echo $uri === 'orders' ? 'active' : ''; ?>" href="<?php echo site_url('orders'); ?>">
				<i class="bi bi-receipt"></i> Order
			</a>
			<a class="nav-link <?php echo $uri === 'customers' ? 'active' : ''; ?>" href="<?php echo site_url('customers'); ?>">
				<i class="bi bi-people"></i> Pelanggan
			</a>
			<a class="nav-link <?php echo $uri === 'services' ? 'active' : ''; ?>" href="<?php echo site_url('services'); ?>">
				<i class="bi bi-tags"></i> Layanan
			</a>
		</nav>

		<div class="mt-auto admin-sidebar-footer">
			<div class="admin-user">
				<div class="avatar" aria-hidden="true"><i class="bi bi-person"></i></div>
				<div class="meta">
					<div class="name"><?php echo isset($current_user['name']) ? e($current_user['name']) : 'Admin'; ?></div>
					<div class="role">Administrator</div>
				</div>
			</div>
			<a class="btn btn-outline-light btn-sm w-100 mt-3" href="<?php echo site_url('logout'); ?>">
				<i class="bi bi-box-arrow-right"></i> Logout
			</a>
		</div>
	</div>
</div>
