<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="card">
	<div class="card-body">
		<?php if (validation_errors()): ?>
			<div class="alert alert-danger"><?php echo validation_errors(); ?></div>
		<?php endif; ?>

		<form method="post">
			<div class="row g-3">
				<div class="col-md-6">
					<label class="form-label">Pelanggan</label>
					<select class="form-select" name="customer_id" required>
						<option value="">-- pilih --</option>
						<?php foreach ($customers as $c): ?>
							<option value="<?php echo (int) $c->id; ?>" <?php echo set_select('customer_id', $c->id, $row && (int) $row->customer_id === (int) $c->id); ?>>
								<?php echo e($c->name); ?>
							</option>
						<?php endforeach; ?>
					</select>
				</div>
				<div class="col-md-6">
					<label class="form-label">Layanan</label>
					<select class="form-select" name="service_id" required>
						<option value="">-- pilih --</option>
						<?php foreach ($services as $s): ?>
							<option value="<?php echo (int) $s->id; ?>" <?php echo set_select('service_id', $s->id, $row && (int) $row->service_id === (int) $s->id); ?>>
								<?php echo e($s->name); ?> (<?php echo e($s->unit); ?>) - <?php echo rupiah($s->price); ?>
							</option>
						<?php endforeach; ?>
					</select>
				</div>

				<div class="col-md-4">
					<label class="form-label">Qty</label>
					<input type="number" step="0.01" class="form-control" name="qty" value="<?php echo set_value('qty', $row ? $row->qty : ''); ?>" required>
				</div>
				<div class="col-md-4">
					<label class="form-label">Tanggal masuk</label>
					<input type="date" class="form-control" name="pickup_date" value="<?php echo set_value('pickup_date', $row ? $row->pickup_date : date('Y-m-d')); ?>">
				</div>
				<div class="col-md-4">
					<label class="form-label">Estimasi selesai</label>
					<input type="date" class="form-control" name="due_date" value="<?php echo set_value('due_date', $row ? $row->due_date : ''); ?>">
				</div>

				<div class="col-md-4">
					<label class="form-label">Status</label>
					<select class="form-select" name="status" required>
						<?php
							$statuses = array('baru' => 'Baru', 'proses' => 'Diproses', 'selesai' => 'Selesai', 'diambil' => 'Diambil', 'batal' => 'Batal');
							$current = set_value('status', $row ? $row->status : 'baru');
						?>
						<?php foreach ($statuses as $key => $label): ?>
							<option value="<?php echo e($key); ?>" <?php echo $current === $key ? 'selected' : ''; ?>><?php echo e($label); ?></option>
						<?php endforeach; ?>
					</select>
				</div>
				<div class="col-md-8">
					<label class="form-label">Catatan</label>
					<input type="text" class="form-control" name="notes" value="<?php echo set_value('notes', $row ? $row->notes : ''); ?>">
				</div>
			</div>

			<div class="mt-4 d-flex gap-2">
				<button class="btn btn-primary" type="submit"><?php echo $mode === 'edit' ? 'Simpan' : 'Buat Order'; ?></button>
				<a class="btn btn-outline-secondary" href="<?php echo site_url('orders'); ?>">Kembali</a>
			</div>
		</form>
	</div>
</div>

