<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
	<div class="text-muted">Kelola order laundry</div>
	<a href="<?php echo site_url('orders/create'); ?>" class="btn btn-primary">Tambah Order</a>
</div>

<div class="card">
	<div class="table-responsive">
		<table class="table table-striped mb-0">
			<thead>
				<tr>
					<th>Kode</th>
					<th>Pelanggan</th>
					<th>Layanan</th>
					<th>Qty</th>
					<th>Status</th>
					<th>Total</th>
					<th>Bayar</th>
					<th></th>
				</tr>
			</thead>
			<tbody>
				<?php if (!$rows): ?>
					<tr><td colspan="8" class="text-center text-muted py-4">Belum ada order</td></tr>
				<?php endif; ?>
				<?php foreach ($rows as $r): ?>
					<tr>
						<td><?php echo e($r->code); ?></td>
						<td><?php echo e($r->customer_name); ?></td>
						<td><?php echo e($r->service_name); ?></td>
						<td><?php echo (float) $r->qty . ' ' . e($r->service_unit); ?></td>
						<td><?php echo order_status_label($r->status); ?></td>
						<td><?php echo rupiah($r->total); ?></td>
						<td><?php echo rupiah($r->paid_amount); ?></td>
						<td class="text-end">
							<a class="btn btn-sm btn-outline-secondary" href="<?php echo site_url('orders/show/' . $r->id); ?>">Detail</a>
							<a class="btn btn-sm btn-outline-secondary" href="<?php echo site_url('orders/edit/' . $r->id); ?>">Edit</a>
							<form method="post" action="<?php echo site_url('orders/delete/' . $r->id); ?>" class="d-inline" onsubmit="return confirm('Hapus order ini?')">
								<button type="submit" class="btn btn-sm btn-outline-danger">Hapus</button>
							</form>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	</div>
</div>

