<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="row g-3 mb-3">
	<div class="col-lg-7">
		<div class="card">
			<div class="card-header d-flex justify-content-between align-items-center">
				<div class="fw-semibold">Order <?php echo e($row->code); ?></div>
				<div class="d-flex gap-2">
					<a class="btn btn-sm btn-outline-secondary" href="<?php echo site_url('orders/edit/' . $row->id); ?>">Edit</a>
					<a class="btn btn-sm btn-primary" href="<?php echo site_url('orders'); ?>">Kembali</a>
				</div>
			</div>
			<div class="card-body">
				<div class="row g-3">
					<div class="col-md-6">
						<div class="text-muted small">Pelanggan</div>
						<div class="fw-semibold"><?php echo e($row->customer_name); ?></div>
						<div class="small text-muted"><?php echo e($row->customer_phone); ?></div>
						<div class="small text-muted"><?php echo e($row->customer_address); ?></div>
					</div>
					<div class="col-md-6">
						<div class="text-muted small">Layanan</div>
						<div class="fw-semibold"><?php echo e($row->service_name); ?></div>
						<div class="small text-muted">
							Qty: <?php echo (float) $row->qty . ' ' . e($row->service_unit); ?> • Harga: <?php echo rupiah($row->service_price); ?>
						</div>
					</div>
					<div class="col-md-4">
						<div class="text-muted small">Status</div>
						<div><?php echo order_status_label($row->status); ?></div>
					</div>
					<div class="col-md-4">
						<div class="text-muted small">Tanggal masuk</div>
						<div><?php echo $row->pickup_date ? e($row->pickup_date) : '-'; ?></div>
					</div>
					<div class="col-md-4">
						<div class="text-muted small">Estimasi selesai</div>
						<div><?php echo $row->due_date ? e($row->due_date) : '-'; ?></div>
					</div>
					<div class="col-12">
						<div class="text-muted small">Catatan</div>
						<div><?php echo $row->notes ? e($row->notes) : '-'; ?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-lg-5">
		<div class="card">
			<div class="card-header fw-semibold">Ringkasan</div>
			<div class="card-body">
				<div class="d-flex justify-content-between">
					<div class="text-muted">Total</div>
					<div class="fw-semibold"><?php echo rupiah($row->total); ?></div>
				</div>
				<div class="d-flex justify-content-between mt-2">
					<div class="text-muted">Terbayar</div>
					<div class="fw-semibold"><?php echo rupiah($row->paid_amount); ?></div>
				</div>
				<div class="d-flex justify-content-between mt-2">
					<?php if ($row->paid_amount > $row->total): ?>
						<div class="text-success fw-bold">Kembalian</div>
						<div class="fw-bold text-success"><?php echo rupiah((float) $row->paid_amount - (float) $row->total); ?></div>
					<?php else: ?>
						<div class="text-muted">Sisa</div>
						<div class="fw-semibold"><?php echo rupiah($remaining); ?></div>
					<?php endif; ?>
				</div>
				<hr>
				
				<?php 
					// Logic for Single Payment Edit
					$existing_payment = $payments ? $payments[0] : null; 
					$form_action = $existing_payment 
						? site_url('payments/edit/' . $existing_payment->id) 
						: site_url('payments/create/' . $row->id);
					$btn_text = $existing_payment ? 'Update Pembayaran' : 'Simpan Pembayaran';
					$val_amount = $existing_payment ? (float)$existing_payment->amount : '';
					$val_method = $existing_payment ? $existing_payment->method : 'cash';
					$val_note = $existing_payment ? $existing_payment->note : '';
				?>

				<form method="post" action="<?php echo $form_action; ?>">
					<div class="mb-2">
						<label class="form-label"><?php echo $existing_payment ? 'Edit Pembayaran' : 'Tambah Pembayaran'; ?></label>
						<input type="number" step="0.01" class="form-control" name="amount" placeholder="Nominal" value="<?php echo $val_amount; ?>" required>
					</div>
					<div class="mb-2">
						<input type="text" class="form-control" name="method" placeholder="Metode (cash/transfer/dll)" value="<?php echo $val_method; ?>" required>
					</div>
					<div class="mb-3">
						<input type="text" class="form-control" name="note" placeholder="Catatan (opsional)" value="<?php echo $val_note; ?>">
					</div>
					<button type="submit" class="btn <?php echo $existing_payment ? 'btn-warning' : 'btn-success'; ?> w-100"><?php echo $btn_text; ?></button>
				</form>
			</div>
		</div>
	</div>
</div>

<div class="card">
	<div class="card-header fw-semibold">Riwayat Pembayaran</div>
	<div class="table-responsive">
		<table class="table table-striped mb-0">
			<thead>
				<tr>
					<th>Tanggal</th>
					<th>Metode</th>
					<th>Nominal</th>
					<th>Catatan</th>
					<th class="text-end">Aksi</th>
				</tr>
			</thead>
			<tbody>
				<?php if (!$payments): ?>
					<tr><td colspan="5" class="text-center text-muted py-4">Belum ada pembayaran</td></tr>
				<?php endif; ?>
				<?php foreach ($payments as $p): ?>
					<tr>
						<td><?php echo e($p->paid_at); ?></td>
						<td><?php echo e($p->method); ?></td>
						<td><?php echo rupiah($p->amount); ?></td>
						<td><?php echo e($p->note); ?></td>
						<td class="text-end">
							<button type="button" class="btn btn-sm btn-outline-primary" onclick="populatePayment('<?php echo $p->id; ?>', '<?php echo $p->amount; ?>', '<?php echo $p->method; ?>', '<?php echo e($p->note); ?>')">Edit</button>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	</div>
</div>

<script>
function populatePayment(id, amount, method, note) {
	// Simple script to scroll to form and maybe populate it if we weren't already doing Single Payment Logic
	// But since we are doing Single Payment Logic which auto-populates the FIRST payment, this is mostly for if there are multiple.
	// However, user asked for "Single Payment", so likely there will only be one. 
	// If there are multiple (legacy data), this helps select which one to edit.
	
	const form = document.querySelector('form[action*="payments/"]');
	form.action = "<?php echo site_url('payments/edit/'); ?>" + id;
	form.querySelector('[name="amount"]').value = amount;
	form.querySelector('[name="method"]').value = method;
	form.querySelector('[name="note"]').value = note;
	form.querySelector('button[type="submit"]').textContent = "Update Pembayaran";
	form.querySelector('button[type="submit"]').className = "btn btn-warning w-100";
	form.scrollIntoView({ behavior: 'smooth' });
}
</script>

