<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="card shadow-soft">
	<div class="card-body p-4 p-lg-5">
		<?php if (validation_errors()): ?>
			<div class="alert alert-danger"><?php echo validation_errors(); ?></div>
		<?php endif; ?>

		<form method="post">
			<div class="row g-3">
				<div class="col-md-6">
					<label class="form-label">Nama outlet</label>
					<input type="text" class="form-control" name="name" value="<?php echo set_value('name', $row ? $row->name : ''); ?>" required>
				</div>
				<div class="col-md-6">
					<label class="form-label">Status</label>
					<select class="form-select" name="is_active" required>
						<?php $active = set_value('is_active', $row ? (string) $row->is_active : '1'); ?>
						<option value="1" <?php echo $active === '1' ? 'selected' : ''; ?>>Aktif</option>
						<option value="0" <?php echo $active === '0' ? 'selected' : ''; ?>>Nonaktif</option>
					</select>
				</div>
				<div class="col-12">
					<label class="form-label">Alamat</label>
					<input type="text" class="form-control" name="address" value="<?php echo set_value('address', $row ? $row->address : ''); ?>">
				</div>
				<div class="col-md-6">
					<label class="form-label">Jam buka</label>
					<input type="text" class="form-control" name="hours" placeholder="08.00 - 21.00" value="<?php echo set_value('hours', $row ? $row->hours : ''); ?>">
				</div>
				<div class="col-md-6">
					<label class="form-label">Telepon</label>
					<input type="text" class="form-control" name="phone" value="<?php echo set_value('phone', $row ? $row->phone : ''); ?>">
				</div>
				<div class="col-md-6">
					<label class="form-label">WhatsApp (angka saja)</label>
					<input type="text" class="form-control" name="whatsapp" placeholder="62822xxxx" value="<?php echo set_value('whatsapp', $row ? $row->whatsapp : ''); ?>">
				</div>
				<div class="col-md-6">
					<label class="form-label">Catatan</label>
					<input type="text" class="form-control" name="notes" value="<?php echo set_value('notes', $row ? $row->notes : ''); ?>">
				</div>
				<div class="col-12">
					<label class="form-label">URL Google Maps (embed)</label>
					<input type="text" class="form-control" name="map_url" placeholder="https://www.google.com/maps?q=Jakarta&output=embed" value="<?php echo set_value('map_url', $row ? $row->map_url : ''); ?>">
					<div class="form-text">Contoh: buka Google Maps → Share → Embed a map → salin URL src (atau gunakan format `...&output=embed`).</div>
				</div>
			</div>

			<div class="d-flex gap-2 mt-4">
				<button class="btn btn-brand" type="submit"><i class="bi bi-save"></i> <?php echo $mode === 'edit' ? 'Simpan' : 'Tambah'; ?></button>
				<a class="btn btn-outline-secondary" href="<?php echo site_url('outlets'); ?>">Kembali</a>
			</div>
		</form>
	</div>
</div>

