<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2 mb-3">
	<div class="text-muted">Kelola outlet yang tampil di halaman publik.</div>
	<a href="<?php echo site_url('outlets/create'); ?>" class="btn btn-brand"><i class="bi bi-plus-lg"></i> Tambah Outlet</a>
</div>

<div class="card shadow-soft">
	<div class="table-responsive">
		<table class="table table-striped align-middle">
			<thead>
				<tr>
					<th>Nama</th>
					<th>Alamat</th>
					<th>Jam buka</th>
					<th>Status</th>
					<th class="text-end">Aksi</th>
				</tr>
			</thead>
			<tbody>
				<?php if (!$rows): ?>
					<tr><td colspan="5" class="text-center text-muted py-4">Belum ada outlet</td></tr>
				<?php endif; ?>
				<?php foreach ($rows as $r): ?>
					<tr>
						<td class="fw-semibold"><?php echo e($r->name); ?></td>
						<td><?php echo e($r->address); ?></td>
						<td><?php echo e($r->hours); ?></td>
						<td>
							<?php if ((int) $r->is_active === 1): ?>
								<span class="badge text-bg-success">Aktif</span>
							<?php else: ?>
								<span class="badge text-bg-secondary">Nonaktif</span>
							<?php endif; ?>
						</td>
						<td class="text-end">
							<a class="btn btn-sm btn-outline-dark" href="<?php echo site_url('outlets/edit/' . $r->id); ?>"><i class="bi bi-pencil"></i> Edit</a>
							<form method="post" action="<?php echo site_url('outlets/delete/' . $r->id); ?>" class="d-inline" onsubmit="return confirm('Hapus outlet ini?')">
								<button type="submit" class="btn btn-sm btn-outline-danger"><i class="bi bi-trash"></i> Hapus</button>
							</form>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	</div>
</div>

