<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="row g-3">
	<div class="col-lg-8">
		<div class="card shadow-soft">
			<div class="card-body p-4 p-lg-5">
				<div class="d-flex justify-content-between align-items-center gap-2 mb-3">
					<div>
						<div class="text-muted small">Konten Publik</div>
						<div class="h5 mb-0 fw-extrabold">Syarat &amp; Ketentuan</div>
					</div>
					<a class="btn btn-outline-dark btn-sm" href="<?php echo site_url('syarat-ketentuan'); ?>" target="_blank" rel="noopener">
						<i class="bi bi-box-arrow-up-right"></i> Preview
					</a>
				</div>

				<?php if (validation_errors()): ?>
					<div class="alert alert-danger"><?php echo validation_errors(); ?></div>
				<?php endif; ?>

				<form method="post">
					<div class="mb-3">
						<label class="form-label">Judul</label>
						<input type="text" class="form-control" name="title" value="<?php echo set_value('title', $page ? $page->title : 'Syarat & Ketentuan'); ?>" required>
					</div>

					<div class="mb-3">
						<label class="form-label">Konten (HTML)</label>
						<textarea class="form-control" name="content_html" rows="16" required><?php echo set_value('content_html', $page ? $page->content_html : ''); ?></textarea>
						<div class="form-text">
							Boleh pakai tag HTML sederhana seperti: <code>&lt;h2&gt;</code>, <code>&lt;p&gt;</code>, <code>&lt;ul&gt;</code>, <code>&lt;li&gt;</code>, <code>&lt;strong&gt;</code>, <code>&lt;a&gt;</code>.
						</div>
					</div>

					<div class="d-flex gap-2">
						<button class="btn btn-brand" type="submit"><i class="bi bi-save"></i> Simpan</button>
						<a class="btn btn-outline-secondary" href="<?php echo site_url('admin'); ?>">Kembali</a>
					</div>
				</form>
			</div>
		</div>
	</div>

	<div class="col-lg-4">
		<div class="card">
			<div class="card-body">
				<div class="fw-semibold mb-2">Contoh Struktur</div>
				<pre class="small mb-0" style="white-space: pre-wrap;">&lt;h2&gt;Ketentuan Umum&lt;/h2&gt;
&lt;ul&gt;
  &lt;li&gt;...&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;Pembayaran&lt;/h2&gt;
&lt;p&gt;...&lt;/p&gt;</pre>
			</div>
		</div>
	</div>
</div>

