<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php
	$seg1 = $this->uri->segment(1);
	$is_home = ($seg1 === '' || $seg1 === 'beranda');
?>
<!doctype html>
<html lang="id">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title><?php echo isset($title) ? e($title) . ' - ' : ''; ?>Loundri</title>
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Baloo+2:wght@600;700;800&family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
	<link href="<?php echo base_url('assets/public.css'); ?>" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg nav-glass sticky-top">
	<div class="container">
		<a class="navbar-brand d-flex align-items-center gap-2 fw-bold" href="<?php echo site_url('beranda'); ?>">
			<span class="brand-mark" aria-hidden="true">
				<svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M7 3h10v6H7V3Z" stroke="#0ea5a3" stroke-width="2" stroke-linejoin="round"/>
					<path d="M6 9h12v10a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2V9Z" stroke="#0ea5a3" stroke-width="2" stroke-linejoin="round"/>
					<path d="M10 13h4" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
				</svg>
			</span>
			<span><span class="brand-text">Loundri</span> Express</span>
		</a>

		<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navMain" aria-controls="navMain" aria-expanded="false" aria-label="Toggle navigation">
			<span class="navbar-toggler-icon"></span>
		</button>

		<div class="collapse navbar-collapse" id="navMain">
			<ul class="navbar-nav ms-auto mb-3 mb-lg-0 align-items-lg-center gap-lg-1">
				<li class="nav-item">
					<a class="nav-link nav-link-pill <?php echo $is_home ? 'active' : ''; ?>" href="<?php echo site_url('beranda'); ?>">Beranda</a>
				</li>
				<li class="nav-item">
					<a class="nav-link nav-link-pill <?php echo $seg1 === 'outlet' ? 'active' : ''; ?>" href="<?php echo site_url('outlet'); ?>">Outlet</a>
				</li>
				<li class="nav-item">
					<a class="nav-link nav-link-pill <?php echo $seg1 === 'kemitraan' ? 'active' : ''; ?>" href="<?php echo site_url('kemitraan'); ?>">Kemitraan</a>
				</li>
				<li class="nav-item">
					<a class="nav-link nav-link-pill <?php echo $seg1 === 'cek-status' ? 'active' : ''; ?>" href="<?php echo site_url('cek-status'); ?>">Cek Status</a>
				</li>
				<li class="nav-item">
					<a class="nav-link nav-link-pill <?php echo $seg1 === 'syarat-ketentuan' ? 'active' : ''; ?>" href="<?php echo site_url('syarat-ketentuan'); ?>">Syarat</a>
				</li>
			</ul>

			<div class="d-grid d-lg-flex gap-2 ms-lg-2">
				<a class="btn btn-outline-dark nav-cta" href="<?php echo site_url('admin'); ?>">Admin</a>
				<a class="btn btn-brand text-white nav-cta" href="<?php echo site_url('beranda#reservasi'); ?>">Reservasi</a>
			</div>
		</div>
	</div>
</nav>
