<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php $this->load->view('public/_header', get_defined_vars()); ?>

<section class="brand-gradient border-bottom">
	<div class="container py-5">
		<div class="row align-items-center g-4 g-lg-5">
			<div class="col-lg-6">
				<div class="d-inline-flex align-items-center gap-2 mb-3">
					<span class="badge text-bg-light badge-pill border">Pickup cepat</span>
					<span class="badge text-bg-light badge-pill border">Express</span>
					<span class="badge text-bg-light badge-pill border">Harga terjangkau</span>
				</div>
				<h1 class="display-4 fw-extrabold heading-bubble title-outline lh-1 mb-3">
					No.1 Laundry Express di Indonesia
				</h1>
				<p class="lead text-muted mb-4">
					Jadwalkan penjemputan, pantau status cucian, dan beres tanpa ribet.
				</p>
				<div class="d-flex flex-column flex-sm-row gap-2">
					<a href="<?php echo site_url('beranda#reservasi'); ?>" class="btn btn-brand text-white btn-lg px-4">Reservasi</a>
					<a href="<?php echo site_url('cek-status'); ?>" class="btn btn-outline-dark btn-lg px-4">Cek Status Cucianmu</a>
				</div>
				<div class="mt-4 small text-muted">
					Buka setiap hari • Estimasi selesai sesuai layanan • Support WhatsApp
				</div>
			</div>
			<div class="col-lg-6">
				<img class="img-fluid" src="<?php echo base_url('assets/img/hero-laundry.svg'); ?>" alt="Ilustrasi laundry">
			</div>
		</div>
	</div>
</section>

<section class="section-sm" id="reservasi">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-10">
				<div class="bg-white rounded-4 border shadow-soft p-4 p-lg-5">
					<div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-2 mb-3">
						<div>
							<h2 class="h3 fw-bold mb-1">Reservasi Laundry</h2>
							<div class="text-muted">Isi data di bawah untuk jadwalkan penjemputan.</div>
						</div>
						<a class="btn btn-outline-dark" href="<?php echo site_url('cek-status'); ?>">Sudah punya kode? Cek status</a>
					</div>

					<?php if ($this->session->flashdata('success')): ?>
						<div class="alert alert-success"><?php echo $this->session->flashdata('success'); ?></div>
					<?php endif; ?>
					<?php if ($this->session->flashdata('error')): ?>
						<div class="alert alert-danger"><?php echo $this->session->flashdata('error'); ?></div>
					<?php endif; ?>

					<form method="post" action="<?php echo site_url('reservasi'); ?>">
						<div class="row g-3">
							<div class="col-md-4">
								<input class="form-control form-control-lg" name="name" placeholder="Nama" required>
							</div>
							<div class="col-md-4">
								<input class="form-control form-control-lg" name="address" placeholder="Alamat">
							</div>
							<div class="col-md-4">
								<input class="form-control form-control-lg" name="whatsapp" placeholder="Whatsapp (08xxxx)">
							</div>
							<div class="col-md-4">
								<select class="form-select form-select-lg" name="service_id">
									<option value="">Pilih layanan</option>
									<?php foreach ($services as $s): ?>
										<option value="<?php echo (int) $s->id; ?>"><?php echo e($s->name); ?> - <?php echo rupiah($s->price); ?>/<?php echo e($s->unit); ?></option>
									<?php endforeach; ?>
								</select>
							</div>
							<div class="col-md-4">
								<input class="form-control form-control-lg" type="date" name="pickup_date" placeholder="Tanggal Penjemputan">
							</div>
							<div class="col-md-4">
								<input class="form-control form-control-lg" type="time" name="pickup_time" placeholder="Jam Penjemputan">
							</div>
							<div class="col-12">
								<input class="form-control form-control-lg" name="notes" placeholder="Catatan (opsional)">
							</div>
							<div class="col-12">
								<button class="btn btn-brand text-white btn-lg w-100" type="submit">Pickup Now</button>
								<div class="small text-muted mt-2">Setelah submit, Anda akan mendapat kode reservasi untuk cek status.</div>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="section services-bg">
	<div class="container">
		<div class="text-center mb-4">
			<div class="small text-muted">Layanan</div>
			<h2 class="h1 fw-extrabold heading-bubble title-outline mb-2">Layanan Laundry</h2>
			<div class="text-muted">Pilih layanan sesuai kebutuhan Anda.</div>
		</div>

		<?php
			$serviceIcons = array(
				0 => '<path d="M8 3h8a2 2 0 0 1 2 2v2H6V5a2 2 0 0 1 2-2Z" fill="rgba(14,165,163,.20)"/><path d="M6 7h12v12a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2V7Z" stroke="#0ea5a3" stroke-width="2" stroke-linejoin="round"/><path d="M10 12h4" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>',
				1 => '<path d="M7 3h10l-1 6H8L7 3Z" fill="rgba(14,165,163,.20)"/><path d="M9 9h6l2 4v6a2 2 0 0 1-2 2H9a2 2 0 0 1-2-2v-6l2-4Z" stroke="#0ea5a3" stroke-width="2" stroke-linejoin="round"/>',
				2 => '<path d="M6 12c2-5 10-5 12 0 2 5-2 10-6 10s-8-5-6-10Z" fill="rgba(14,165,163,.20)"/><path d="M8 12c1-3 7-3 8 0 1 3-1 6-4 6s-5-3-4-6Z" stroke="#0ea5a3" stroke-width="2"/>',
				3 => '<path d="M6 18c0-4 3-7 7-7h5v10a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2v-3Z" stroke="#0ea5a3" stroke-width="2" fill="rgba(14,165,163,.14)"/><path d="M9 11V9a3 3 0 0 1 3-3h1a3 3 0 0 1 3 3v2" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>',
			);
		?>
		<?php $service_count = is_array($services) ? count($services) : 0; ?>
		<div class="row g-3 g-md-4">
			<?php if (!$services): ?>
				<div class="col-12">
					<div class="alert alert-warning">Belum ada layanan. Tambahkan di admin: <a href="<?php echo site_url('admin'); ?>">/admin</a>.</div>
				</div>
			<?php endif; ?>
			<?php foreach ($services as $idx => $s): ?>
				<div class="col-6 col-md-3 col-lg-3">
					<div class="card service-card h-100">
						<div class="card-body text-center p-4">
							<div class="service-icon">
								<svg width="44" height="44" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
									<?php echo $serviceIcons[$idx % 4]; ?>
								</svg>
							</div>
							<div class="heading-bubble fw-bold fs-5 mb-1"><?php echo e($s->name); ?></div>
							<div class="text-muted small"><?php echo rupiah($s->price); ?> / <?php echo e($s->unit); ?></div>
						</div>
					</div>
				</div>
			<?php endforeach; ?>
			<?php if ($service_count > 0 && $service_count < 4): ?>
				<div class="col-6 col-md-3 col-lg-3">
					<div class="card service-card h-100">
						<div class="card-body text-center p-4">
							<div class="service-icon">
								<svg width="44" height="44" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
									<path d="M12 21a8 8 0 1 0 0-16 8 8 0 0 0 0 16Z" stroke="#0ea5a3" stroke-width="2"/>
									<path d="M8 12h8" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
									<path d="M12 8v8" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
								</svg>
							</div>
							<div class="heading-bubble fw-bold fs-5 mb-1">Layanan Lainnya</div>
							<div class="text-muted small">Tambah layanan di Admin</div>
						</div>
					</div>
				</div>
			<?php endif; ?>
		</div>

		<div class="text-center mt-4">
			<a class="btn btn-outline-dark" href="<?php echo site_url('beranda#reservasi'); ?>">Reservasi & Pilih Layanan</a>
		</div>
	</div>
</section>

<section class="section bg-white">
	<div class="container">
		<div class="row align-items-center g-4 g-lg-5">
			<div class="col-lg-5">
				<div class="position-relative">
					<div class="rounded-4 border shadow-soft p-4 brand-gradient">
						<div class="heading-bubble fw-extrabold fs-1 title-outline lh-1 mb-2">Laundry</div>
						<div class="text-muted">Bersih, wangi, higienis, dan tepat waktu.</div>
						<div class="mt-3 d-flex gap-2 flex-wrap">
							<span class="badge text-bg-light border">Tim profesional</span>
							<span class="badge text-bg-light border">Harga jelas</span>
							<span class="badge text-bg-light border">Update status</span>
						</div>
					</div>
					<div class="stat-badge">
						<div class="d-flex align-items-center gap-3">
							<div class="rounded-circle border" style="width:56px;height:56px;display:grid;place-items:center;background:rgba(14,165,163,.10);">
								<div class="heading-bubble fw-extrabold" style="color:var(--brand);font-size:20px;">10+</div>
							</div>
							<div>
								<div class="fw-semibold">Tahun Pengalaman</div>
								<div class="small text-muted">Melayani pelanggan harian</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-lg-7">
				<div class="small text-muted">Tentang Kami</div>
				<h2 class="h1 fw-extrabold heading-bubble title-outline mb-3">Laundry Bersih, Wangi, Higienis, dan Tepat Waktu</h2>
				<p class="text-muted mb-3">
					Loundri Express menerima laundry kiloan dan satuan. Kami mengutamakan kualitas cucian dan pelayanan yang ramah.
				</p>
				<p class="text-muted mb-4">
					Kami juga melayani kebutuhan laundry untuk kantor, sekolah, konveksi, dan lainnya. Hubungi kami untuk penawaran khusus kontrak.
				</p>
				<div class="feature-card p-3 bg-light">
					<div class="d-flex gap-3 align-items-start">
						<div class="rounded-3 p-2" style="background: rgba(14,165,163,.12);">
							<svg width="26" height="26" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
								<path d="M12 2v8" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
								<path d="M8.5 6.5 12 10l3.5-3.5" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								<path d="M7 22h10" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
								<path d="M6 22c0-4 3-7 6-7s6 3 6 7" stroke="#0ea5a3" stroke-width="2"/>
							</svg>
						</div>
						<div>
							<div class="fw-semibold">Stop mencuci sendiri</div>
							<div class="text-muted small">Maksimalkan waktu Anda, biarkan tim kami yang mengurus cucian.</div>
						</div>
					</div>
				</div>
				<div class="mt-4 d-flex gap-2 flex-wrap">
					<a href="<?php echo site_url('beranda#reservasi'); ?>" class="btn btn-brand text-white">Reservasi</a>
					<a href="<?php echo site_url('outlet'); ?>" class="btn btn-outline-dark">Lihat Outlet</a>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="section services-bg">
	<div class="container">
		<div class="text-center mb-4">
			<div class="small text-muted">Keunggulan</div>
			<h2 class="h1 fw-extrabold heading-bubble title-outline mb-2">Mengapa Harus Loundri?</h2>
			<div class="text-muted">Alasan pelanggan memilih kami.</div>
		</div>
		<div class="row g-3 g-lg-4 justify-content-center">
			<div class="col-md-6 col-lg-4">
				<div class="feature-card bg-white p-4 h-100 text-center">
					<div class="service-icon mx-auto">
						<svg width="44" height="44" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							<path d="M12 21a8 8 0 1 0 0-16 8 8 0 0 0 0 16Z" stroke="#0ea5a3" stroke-width="2"/>
							<path d="M9 12l2 2 4-5" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
						</svg>
					</div>
					<div class="heading-bubble fw-bold fs-4 mb-2">Merk Terpercaya</div>
					<div class="text-muted">Dipercaya pelanggan dengan standar kualitas yang konsisten.</div>
				</div>
			</div>
			<div class="col-md-6 col-lg-4">
				<div class="feature-card bg-white p-4 h-100 text-center">
					<div class="service-icon mx-auto">
						<svg width="44" height="44" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							<path d="M16 11c1.66 0 3-1.79 3-4s-1.34-4-3-4-3 1.79-3 4 1.34 4 3 4Z" stroke="#0ea5a3" stroke-width="2"/>
							<path d="M8 11c1.66 0 3-1.79 3-4S9.66 3 8 3 5 4.79 5 7s1.34 4 3 4Z" stroke="#0ea5a3" stroke-width="2"/>
							<path d="M3 21c0-3 2.5-5 5-5" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
							<path d="M21 21c0-3-2.5-5-5-5" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
							<path d="M8 16h8c2.5 0 4 2 4 5" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
						</svg>
					</div>
					<div class="heading-bubble fw-bold fs-4 mb-2">Tim Profesional</div>
					<div class="text-muted">Penanganan hati-hati, rapi, dan penuh perhatian.</div>
				</div>
			</div>
			<div class="col-md-6 col-lg-4">
				<div class="feature-card bg-white p-4 h-100 text-center">
					<div class="service-icon mx-auto">
						<svg width="44" height="44" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
							<path d="M3 13h13l5-4v10l-5-4H3v-2Z" stroke="#0ea5a3" stroke-width="2" stroke-linejoin="round"/>
							<path d="M8 11V7a4 4 0 0 1 8 0v4" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
						</svg>
					</div>
					<div class="heading-bubble fw-bold fs-4 mb-2">Express Cepat</div>
					<div class="text-muted">Untuk Anda yang butuh cepat dan efisien.</div>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="section bg-white">
	<div class="container">
		<div class="row align-items-center g-4">
			<div class="col-lg-5">
				<div class="heading-bubble fw-extrabold title-outline display-6 lh-1">
					Bayar Laundry, semudah ngomong “Sarangahe”
				</div>
				<div class="text-muted mt-3">Mendukung berbagai metode pembayaran (contoh).</div>
			</div>
			<div class="col-lg-7">
				<div class="row g-3">
					<div class="col-6 col-md-4"><div class="pay-logo fw-semibold">VISA</div></div>
					<div class="col-6 col-md-4"><div class="pay-logo fw-semibold">GPN</div></div>
					<div class="col-6 col-md-4"><div class="pay-logo fw-semibold">ShopeePay</div></div>
					<div class="col-6 col-md-4"><div class="pay-logo fw-semibold">Jenius</div></div>
					<div class="col-6 col-md-4"><div class="pay-logo fw-semibold">LinkAja</div></div>
					<div class="col-6 col-md-4"><div class="pay-logo fw-semibold">BCA</div></div>
				</div>
			</div>
		</div>
	</div>
</section>

<?php $this->load->view('public/_footer', get_defined_vars()); ?>
