<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php $this->load->view('public/_header', get_defined_vars()); ?>

<section class="page-hero">
	<div class="container py-5">
		<div class="row align-items-center g-4">
			<div class="col-lg-8">
				<div class="small text-muted">Kemitraan</div>
				<h1 class="display-6 fw-extrabold heading-bubble title-outline mb-2">Gabung Jadi Mitra Loundri</h1>
				<div class="text-muted">
					Perlu layanan laundry rutin untuk bisnis Anda? Atau ingin kerja sama drop point/outlet? Kami siap bantu dengan skema yang fleksibel.
				</div>
				<div class="d-flex flex-wrap gap-2 mt-3">
					<span class="partner-pill">Harga kontrak</span>
					<span class="partner-pill">Pickup terjadwal</span>
					<span class="partner-pill">Laporan bulanan</span>
					<span class="partner-pill">Support prioritas</span>
				</div>
			</div>
			<div class="col-lg-4">
				<div class="feature-card bg-white p-4">
					<div class="d-flex gap-3 align-items-start">
						<div class="icon-bubble">
							<svg width="22" height="22" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
								<path d="M16 11c1.66 0 3-1.79 3-4s-1.34-4-3-4-3 1.79-3 4 1.34 4 3 4Z" stroke="#0ea5a3" stroke-width="2"/>
								<path d="M8 11c1.66 0 3-1.79 3-4S9.66 3 8 3 5 4.79 5 7s1.34 4 3 4Z" stroke="#0ea5a3" stroke-width="2"/>
								<path d="M3 21c0-3 2.5-5 5-5" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
								<path d="M21 21c0-3-2.5-5-5-5" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
								<path d="M8 16h8c2.5 0 4 2 4 5" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
							</svg>
						</div>
						<div>
							<div class="fw-semibold mb-1">Respons cepat</div>
							<div class="small text-muted">Diskusikan kebutuhan Anda via WhatsApp.</div>
							<a class="btn btn-brand text-white btn-sm mt-3" target="_blank" rel="noopener" href="https://wa.me/6282223284334">Konsultasi</a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="section-sm">
	<div class="container">
		<div class="row g-4">
			<div class="col-lg-7">
				<div class="text-muted small">Untuk siapa?</div>
				<h2 class="h2 fw-extrabold heading-bubble title-outline mb-3">Cocok untuk bisnis & komunitas</h2>

				<div class="row g-3">
					<div class="col-md-6">
						<div class="feature-card bg-white p-4 h-100">
							<div class="fw-semibold mb-1">Kantor & Perusahaan</div>
							<div class="text-muted small">Laundry rutin untuk seragam, handuk, dan kebutuhan operasional.</div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="feature-card bg-white p-4 h-100">
							<div class="fw-semibold mb-1">Sekolah & Asrama</div>
							<div class="text-muted small">Skema antar-jemput terjadwal dengan volume besar.</div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="feature-card bg-white p-4 h-100">
							<div class="fw-semibold mb-1">Klinik & Rumah Sakit</div>
							<div class="text-muted small">Proses higienis dan SOP sesuai kebutuhan.</div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="feature-card bg-white p-4 h-100">
							<div class="fw-semibold mb-1">Konveksi & UMKM</div>
							<div class="text-muted small">Penanganan cepat untuk kebutuhan produksi.</div>
						</div>
					</div>
				</div>
			</div>

			<div class="col-lg-5">
				<div class="feature-card bg-white p-4 shadow-soft">
					<div class="fw-semibold mb-2">Yang Anda dapatkan</div>
					<ul class="text-muted mb-0">
						<li>Harga kontrak sesuai volume</li>
						<li>Pickup & drop terjadwal</li>
						<li>Prioritas antrian (opsional)</li>
						<li>Rekap transaksi bulanan (opsional)</li>
						<li>Customer support prioritas</li>
					</ul>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="section services-bg">
	<div class="container">
		<div class="text-center mb-4">
			<div class="small text-muted">Proses</div>
			<h2 class="h1 fw-extrabold heading-bubble title-outline mb-2">Cara Kerja Sama</h2>
			<div class="text-muted">Tiga langkah sederhana untuk mulai bermitra.</div>
		</div>

		<div class="row g-3 g-lg-4 justify-content-center">
			<div class="col-md-6 col-lg-4">
				<div class="step-card p-4 h-100">
					<div class="d-flex gap-3">
						<div class="step-num">1</div>
						<div>
							<div class="fw-semibold mb-1">Konsultasi Kebutuhan</div>
							<div class="text-muted small">Ceritakan volume, jenis barang, lokasi, dan jadwal pickup.</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-6 col-lg-4">
				<div class="step-card p-4 h-100">
					<div class="d-flex gap-3">
						<div class="step-num">2</div>
						<div>
							<div class="fw-semibold mb-1">Penawaran & Kesepakatan</div>
							<div class="text-muted small">Kami kirim opsi harga dan SLA, lalu finalisasi kerja sama.</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-6 col-lg-4">
				<div class="step-card p-4 h-100">
					<div class="d-flex gap-3">
						<div class="step-num">3</div>
						<div>
							<div class="fw-semibold mb-1">Mulai Operasional</div>
							<div class="text-muted small">Pickup terjadwal berjalan, status bisa dipantau dan direkap.</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="section-sm">
	<div class="container">
		<div class="row g-4 align-items-stretch">
			<div class="col-lg-7">
				<div class="feature-card bg-white p-4 h-100">
					<div class="fw-semibold mb-2">FAQ singkat</div>
					<div class="accordion" id="partnerFaq">
						<div class="accordion-item">
							<h2 class="accordion-header" id="pf1">
								<button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#pc1" aria-expanded="true" aria-controls="pc1">
									Minimal kontrak berapa lama?
								</button>
							</h2>
							<div id="pc1" class="accordion-collapse collapse show" aria-labelledby="pf1" data-bs-parent="#partnerFaq">
								<div class="accordion-body text-muted">Bisa fleksibel. Umumnya 1–3 bulan (tergantung volume dan kebutuhan).</div>
							</div>
						</div>
						<div class="accordion-item">
							<h2 class="accordion-header" id="pf2">
								<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#pc2" aria-expanded="false" aria-controls="pc2">
									Apakah bisa pickup terjadwal?
								</button>
							</h2>
							<div id="pc2" class="accordion-collapse collapse" aria-labelledby="pf2" data-bs-parent="#partnerFaq">
								<div class="accordion-body text-muted">Bisa. Kita tentukan jadwal dan rute pickup bersama di awal kerja sama.</div>
							</div>
						</div>
						<div class="accordion-item">
							<h2 class="accordion-header" id="pf3">
								<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#pc3" aria-expanded="false" aria-controls="pc3">
									Apakah ada laporan bulanan?
								</button>
							</h2>
							<div id="pc3" class="accordion-collapse collapse" aria-labelledby="pf3" data-bs-parent="#partnerFaq">
								<div class="accordion-body text-muted">Opsional. Kami bisa buat rekap transaksi dan volume tiap bulan.</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="col-lg-5">
				<div class="footer-cta p-4 p-lg-5 h-100">
					<div class="footer-title fs-3 mb-2">Mulai diskusi sekarang</div>
					<div class="text-muted mb-3">Klik tombol di bawah untuk konsultasi kebutuhan kemitraan Anda.</div>
					<a class="btn btn-brand text-white btn-lg w-100" target="_blank" rel="noopener" href="https://wa.me/6282223284334">Chat WhatsApp</a>
					<div class="small text-muted mt-3">
						Tip: sertakan info lokasi, jenis laundry, estimasi volume, dan jadwal pickup.
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<?php $this->load->view('public/_footer', get_defined_vars()); ?>
