<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php $this->load->view('public/_header', get_defined_vars()); ?>

<section class="page-hero">
	<div class="container py-5">
		<div class="row align-items-center g-4">
			<div class="col-lg-8">
				<div class="small text-muted">Lokasi</div>
				<h1 class="display-6 fw-extrabold heading-bubble title-outline mb-2">Outlet Loundri</h1>
				<div class="text-muted">
					Datang langsung ke outlet atau reservasi pickup dari beranda. Di bawah ini contoh struktur data outlet—silakan sesuaikan alamat dan nomor WhatsApp Anda.
				</div>
				<div class="d-flex flex-wrap gap-2 mt-3">
					<span class="outlet-badge">Pickup terjadwal</span>
					<span class="outlet-badge">Buka tiap hari</span>
					<span class="outlet-badge">Support WhatsApp</span>
				</div>
			</div>
			<div class="col-lg-4">
				<div class="feature-card bg-white p-4">
					<div class="d-flex gap-3 align-items-start">
						<div class="icon-bubble">
							<svg width="22" height="22" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
								<path d="M12 22s7-4.4 7-12a7 7 0 1 0-14 0c0 7.6 7 12 7 12Z" stroke="#0ea5a3" stroke-width="2"/>
								<path d="M12 11.5a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Z" stroke="#0ea5a3" stroke-width="2"/>
							</svg>
						</div>
						<div>
							<div class="fw-semibold mb-1">Cari outlet terdekat</div>
							<div class="small text-muted">Gunakan Google Maps untuk navigasi.</div>
							<a class="btn btn-outline-dark btn-sm mt-3" href="<?php echo site_url('beranda#reservasi'); ?>">Reservasi Pickup</a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<?php $outlets = isset($outlets) ? $outlets : array(); ?>

<section class="section-sm">
	<div class="container">
		<div class="row g-4">
			<div class="col-lg-7">
				<div class="row g-3">
					<?php foreach ($outlets as $o): ?>
						<div class="col-12">
							<div class="outlet-card p-4">
								<div class="d-flex flex-column flex-md-row justify-content-between gap-3">
									<div>
										<div class="d-flex align-items-center gap-2 mb-2">
											<div class="icon-bubble">
												<svg width="22" height="22" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
													<path d="M12 21s7-4.4 7-12a7 7 0 1 0-14 0c0 7.6 7 12 7 12Z" stroke="#0ea5a3" stroke-width="2"/>
													<path d="M12 11.5a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Z" stroke="#0ea5a3" stroke-width="2"/>
												</svg>
											</div>
											<div>
												<div class="fw-semibold fs-5"><?php echo e($o->name); ?></div>
												<div class="small text-muted"><?php echo e($o->notes); ?></div>
											</div>
										</div>
										<div class="text-muted">
											<div class="mb-2">
												<span class="fw-semibold">Alamat:</span>
												<span><?php echo e($o->address); ?></span>
											</div>
											<div class="d-flex flex-wrap gap-2">
												<span class="outlet-badge">
													<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
														<path d="M12 8v5l3 2" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
														<path d="M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" stroke="#0ea5a3" stroke-width="2"/>
													</svg>
													Jam buka: <?php echo e($o->hours); ?>
												</span>
												<span class="outlet-badge">
													<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
														<path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.86 19.86 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6A19.86 19.86 0 0 1 2.08 4.18 2 2 0 0 1 4.06 2h3a2 2 0 0 1 2 1.72c.12.86.32 1.7.57 2.5a2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.58-1.09a2 2 0 0 1 2.11-.45c.8.25 1.64.45 2.5.57A2 2 0 0 1 22 16.92Z" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
													</svg>
													<?php echo e($o->phone); ?>
												</span>
											</div>
										</div>
									</div>
									<div class="d-flex flex-column gap-2">
										<?php if (isset($o->whatsapp) && $o->whatsapp): ?>
											<a class="btn btn-brand text-white" target="_blank" rel="noopener" href="<?php echo 'https://wa.me/' . rawurlencode($o->whatsapp); ?>">Chat WhatsApp</a>
										<?php else: ?>
											<a class="btn btn-outline-dark" href="<?php echo site_url('beranda#reservasi'); ?>">Reservasi</a>
										<?php endif; ?>
										<a class="btn btn-outline-dark" href="<?php echo site_url('beranda#reservasi'); ?>">Reservasi</a>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
					<?php if (!$outlets): ?>
						<div class="col-12">
							<div class="alert alert-warning mb-0">Belum ada outlet aktif. Tambahkan lewat admin: <a href="<?php echo site_url('admin'); ?>">/admin</a> → Outlet.</div>
						</div>
					<?php endif; ?>
				</div>
			</div>

			<div class="col-lg-5">
				<div class="map-embed shadow-soft">
					<div class="p-4 border-bottom">
						<div class="fw-semibold">Peta (Google Maps)</div>
						<div class="small text-muted">Ganti embed ini dengan lokasi outlet Anda.</div>
					</div>
					<div class="ratio ratio-4x3">
						<iframe
							title="Google Maps"
							src="<?php echo e(isset($map_url) ? $map_url : 'https://www.google.com/maps?q=Jakarta&output=embed'); ?>"
							style="border:0;"
							loading="lazy"
							referrerpolicy="no-referrer-when-downgrade"></iframe>
					</div>
				</div>

				<div class="feature-card bg-white p-4 mt-4">
					<div class="d-flex gap-3 align-items-start">
						<div class="icon-bubble">
							<svg width="22" height="22" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
								<path d="M12 2v8" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
								<path d="M8.5 6.5 12 10l3.5-3.5" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								<path d="M7 22h10" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
								<path d="M6 22c0-4 3-7 6-7s6 3 6 7" stroke="#0ea5a3" stroke-width="2"/>
							</svg>
						</div>
						<div>
							<div class="fw-semibold mb-1">Tips cepat</div>
							<div class="small text-muted mb-0">Simpan kode reservasi/order untuk cek status di halaman “Cek Status Cucianmu”.</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<?php $this->load->view('public/_footer', get_defined_vars()); ?>
