<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php $this->load->view('public/_header', get_defined_vars()); ?>

<section class="page-hero">
	<div class="container py-5">
		<div class="row align-items-center g-4">
			<div class="col-lg-8">
				<div class="small text-muted">Struk</div>
				<h1 class="display-6 fw-extrabold heading-bubble title-outline mb-2">Struk Reservasi / Order</h1>
				<div class="text-muted">Simpan atau cetak struk ini sebagai bukti. Kode bisa dipakai untuk cek status.</div>
			</div>
			<div class="col-lg-4">
				<div class="feature-card bg-white p-4">
					<div class="d-flex gap-3 align-items-start">
						<div class="icon-bubble">
							<svg width="22" height="22" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
								<path d="M7 3h10v18H7V3Z" stroke="#0ea5a3" stroke-width="2"/>
								<path d="M9 7h6M9 11h6M9 15h4" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
							</svg>
						</div>
						<div>
							<div class="fw-semibold mb-1">Tips</div>
							<div class="small text-muted mb-0">Klik “Download Struk” untuk menyimpan file, atau “Cetak Struk” untuk print.</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="section-sm">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-10">
				<div class="card shadow-soft print-area">
					<div class="card-body p-4 p-lg-5">
						<style>
							.receipt-paper{ font-family: DejaVu Sans, Arial, sans-serif; font-size: 12px; }
							.receipt-paper{ max-width: 760px; margin: 0 auto; padding: 18px; border: 1px solid #ddd; border-radius: 12px; background:#fff; }
							.receipt-head{ display:flex; justify-content: space-between; gap: 12px; align-items: flex-start; }
							.receipt-brand{ font-weight: 800; font-size: 18px; }
							.receipt-sub{ color:#666; margin-top: 2px; }
							.receipt-right{ text-align:right; }
							.receipt-code{ font-weight: 800; font-size: 16px; }
							.receipt-badge{ display:inline-block; padding: 4px 10px; border-radius: 999px; border:1px solid #ddd; font-size: 11px; margin-top: 6px; color:#111; background:#fff; }
							.receipt-hr{ border:0; border-top:1px dashed #ddd; margin: 14px 0; }
							.receipt-grid{ display:grid; grid-template-columns: 1fr 1fr; gap: 10px 14px; }
							.receipt-kv .k{ color:#666; font-size: 11px; }
							.receipt-kv .v{ font-weight: 700; margin-top: 2px; color:#111; }
							.receipt-foot{ margin-top: 6px; color:#666; font-size: 11px; }
						</style>

						<form method="get" action="<?php echo site_url('struk'); ?>" class="print-hide">
							<div class="row g-2 g-md-3 align-items-center">
								<div class="col-md-9">
									<input class="form-control form-control-lg mono" name="code" placeholder="Masukkan kode (RSV-... atau LDRY-...)" value="<?php echo e($code); ?>">
								</div>
								<div class="col-md-3 d-grid">
									<button class="btn btn-brand text-white btn-lg" type="submit">Lihat Struk</button>
								</div>
							</div>
						</form>

						<?php if ($code !== '' && !$result): ?>
							<div class="alert alert-warning mt-4 mb-0">
								Kode <strong class="mono"><?php echo e($code); ?></strong> tidak ditemukan.
							</div>
						<?php endif; ?>

						<?php if ($result): ?>
							<div class="mt-4">
								<?php $this->load->view('public/receipt_snippet', get_defined_vars()); ?>
							</div>

							<div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2 print-hide">
								<div class="small text-muted">
									Cek status kapan saja di: <a href="<?php echo site_url('cek-status?code=' . rawurlencode($result->code)); ?>"><?php echo site_url('cek-status'); ?></a>
								</div>
								<div class="d-flex gap-2">
									<a class="btn btn-outline-dark" href="<?php echo site_url('download-struk?code=' . rawurlencode($result->code)); ?>">Download Struk (PDF)</a>
									<button class="btn btn-brand text-white" type="button" onclick="window.print()">Cetak Struk</button>
								</div>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<?php $this->load->view('public/_footer', get_defined_vars()); ?>
