<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php
	$label_type = $type === 'order' ? 'ORDER' : 'RESERVASI';
	$display_name = $type === 'order' ? $result->customer_name : $result->name;
?>
<div class="receipt-paper">
	<div class="receipt-head">
		<div>
			<div class="receipt-brand">Loundri Express</div>
			<div class="receipt-sub">Struk <?php echo e($label_type); ?></div>
		</div>
		<div class="receipt-right">
			<div class="receipt-code mono"><?php echo e($result->code); ?></div>
			<div class="receipt-badge">Status: <?php echo e($result->status); ?></div>
		</div>
	</div>

	<hr class="receipt-hr">

	<div class="receipt-grid">
		<div class="receipt-kv">
			<div class="k">Nama</div>
			<div class="v"><?php echo e($display_name); ?></div>
		</div>
		<div class="receipt-kv">
			<div class="k">Layanan</div>
			<div class="v"><?php echo e($result->service_name); ?></div>
			<?php if ($type === 'order'): ?>
				<div class="k">Qty: <?php echo (float) $result->qty . ' ' . e($result->service_unit); ?></div>
			<?php endif; ?>
		</div>

			<div class="receipt-kv">
				<div class="k">WhatsApp</div>
				<div class="v"><?php echo $type === 'order' ? e($result->customer_phone) : e($result->whatsapp); ?></div>
			</div>
			<div class="receipt-kv">
				<div class="k">Alamat</div>
				<div class="v"><?php echo $type === 'order' ? e($result->customer_address) : e($result->address); ?></div>
			</div>
			<div class="receipt-kv">
				<div class="k">Tanggal Pickup</div>
				<div class="v"><?php echo $result->pickup_date ? e($result->pickup_date) : '-'; ?></div>
			</div>
			<?php if ($type === 'reservation'): ?>
				<div class="receipt-kv">
					<div class="k">Jam Pickup</div>
					<div class="v"><?php echo $result->pickup_time ? e($result->pickup_time) : '-'; ?></div>
				</div>
			<?php endif; ?>

		<?php if ($type === 'order'): ?>
			<div class="receipt-kv">
				<div class="k">Total</div>
				<div class="v"><?php echo rupiah($result->total); ?></div>
			</div>
			<div class="receipt-kv">
				<div class="k">Terbayar</div>
				<div class="v"><?php echo rupiah($result->paid_amount); ?></div>
			</div>
			<div class="receipt-kv">
				<div class="k">Sisa</div>
				<div class="v"><?php echo rupiah(max(0, (float) $result->total - (float) $result->paid_amount)); ?></div>
			</div>
		<?php endif; ?>
	</div>

	<hr class="receipt-hr">

	<div class="receipt-kv">
		<div class="k">Catatan</div>
		<div class="v"><?php echo $result->notes ? e($result->notes) : '-'; ?></div>
	</div>
	<div class="receipt-kv">
		<div class="k">Dibuat</div>
		<div class="v"><?php echo isset($result->created_at) && $result->created_at ? e($result->created_at) : '-'; ?></div>
	</div>

	<hr class="receipt-hr">
	<div class="receipt-foot">
		<div class="k">Cek status:</div>
		<div class="mono"><?php echo e(site_url('cek-status?code=' . rawurlencode($result->code))); ?></div>
	</div>
</div>

