<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php $this->load->view('public/_header', get_defined_vars()); ?>

<?php
	function status_steps($type)
	{
		if ($type === 'order') {
			return array(
				'baru' => 'Order dibuat',
				'proses' => 'Sedang diproses',
				'selesai' => 'Selesai',
				'diambil' => 'Diambil',
				'batal' => 'Dibatalkan',
			);
		}

		return array(
			'baru' => 'Reservasi masuk',
			'dikonfirmasi' => 'Dikonfirmasi',
			'dipickup' => 'Dalam penjemputan',
			'selesai' => 'Selesai',
			'batal' => 'Dibatalkan',
		);
	}

	function status_progress_index($steps, $status)
	{
		$keys = array_keys($steps);
		$idx = array_search($status, $keys, TRUE);
		return $idx === FALSE ? -1 : (int) $idx;
	}
?>

<section class="page-hero">
	<div class="container py-5">
		<div class="row align-items-center g-4">
			<div class="col-lg-8">
				<div class="small text-muted">Tracking</div>
				<h1 class="display-6 fw-extrabold heading-bubble title-outline mb-2">Cek Status Cucianmu</h1>
				<div class="text-muted">Masukkan kode order <span class="mono">LDRY-...</span> atau kode reservasi <span class="mono">RSV-...</span>.</div>
			</div>
			<div class="col-lg-4">
				<div class="feature-card bg-white p-4">
					<div class="d-flex gap-3 align-items-start">
						<div class="icon-bubble">
							<svg width="22" height="22" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
								<path d="M12 8v5l3 2" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								<path d="M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" stroke="#0ea5a3" stroke-width="2"/>
							</svg>
						</div>
						<div>
							<div class="fw-semibold mb-1">Tip</div>
							<div class="small text-muted mb-0">Simpan kode dari halaman reservasi atau dari admin saat order dibuat.</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="section-sm">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-10">
				<?php if ($this->session->flashdata('success')): ?>
					<div class="alert alert-success"><?php echo $this->session->flashdata('success'); ?></div>
				<?php endif; ?>
				<?php if ($this->session->flashdata('error')): ?>
					<div class="alert alert-danger"><?php echo $this->session->flashdata('error'); ?></div>
				<?php endif; ?>

				<div class="status-card shadow-soft p-4 p-lg-5">
					<form method="get" action="<?php echo site_url('cek-status'); ?>">
						<div class="row g-2 g-md-3 align-items-center">
							<div class="col-md-9">
								<input class="form-control form-control-lg mono" name="code" placeholder="Contoh: LDRY-20251217-0001" value="<?php echo e($code); ?>">
							</div>
							<div class="col-md-3 d-grid">
								<button class="btn btn-brand text-white btn-lg" type="submit">Cek Status</button>
							</div>
						</div>
						<div class="small text-muted mt-2">Contoh: <span class="mono">RSV-20251217-0001</span> atau <span class="mono">LDRY-20251217-0001</span></div>
					</form>

					<?php if ($code !== '' && !$result): ?>
						<div class="alert alert-warning mt-4 mb-0">
							Kode <strong class="mono"><?php echo e($code); ?></strong> tidak ditemukan. Pastikan tidak ada spasi dan formatnya benar.
						</div>
					<?php endif; ?>

					<?php if ($result): ?>
						<?php
							$steps = status_steps($type);
							$progress_idx = status_progress_index($steps, $result->status);
							$label_type = $type === 'order' ? 'Order' : 'Reservasi';
							$display_name = $type === 'order' ? $result->customer_name : $result->name;
						?>
						<hr class="my-5">

						<div class="row g-4">
							<div class="col-lg-7">
								<div class="d-flex justify-content-between flex-wrap gap-2 mb-3">
									<div>
										<div class="text-muted small"><?php echo e($label_type); ?></div>
										<div class="h4 fw-extrabold mb-0 mono"><?php echo e($result->code); ?></div>
									</div>
									<div class="text-lg-end">
										<div class="text-muted small">Status saat ini</div>
										<div class="h6 mb-0"><?php echo order_status_label($result->status); ?></div>
									</div>
								</div>

								<div class="status-timeline">
									<?php $i = 0; foreach ($steps as $k => $text): ?>
										<?php
											$is_done = $progress_idx >= 0 && $i <= $progress_idx && $k !== 'batal';
											$is_cancel = $result->status === 'batal';
											$cls = $is_done ? 'status-step done' : 'status-step';
											if ($is_cancel && $k === 'batal') { $cls = 'status-step done'; }
										?>
										<div class="<?php echo $cls; ?>">
											<div class="fw-semibold"><?php echo e($text); ?></div>
											<div class="small text-muted"><?php echo $k === $result->status ? 'Status aktif' : ''; ?></div>
										</div>
									<?php $i++; endforeach; ?>
								</div>
							</div>

							<div class="col-lg-5">
								<div class="status-kv mb-3">
									<div class="text-muted small">Nama</div>
									<div class="fw-semibold"><?php echo e($display_name); ?></div>
								</div>
								<div class="status-kv mb-3">
									<div class="text-muted small">Layanan</div>
									<div class="fw-semibold"><?php echo e($result->service_name); ?></div>
									<?php if ($type === 'order'): ?>
										<div class="small text-muted">Qty: <?php echo (float) $result->qty . ' ' . e($result->service_unit); ?></div>
									<?php endif; ?>
								</div>

								<?php if ($type === 'order'): ?>
									<div class="row g-2">
										<div class="col-12">
											<div class="status-kv">
												<div class="text-muted small">Total</div>
												<div class="fw-semibold"><?php echo rupiah($result->total); ?></div>
											</div>
										</div>
										<div class="col-6">
											<div class="status-kv">
												<div class="text-muted small">Terbayar</div>
												<div class="fw-semibold"><?php echo rupiah($result->paid_amount); ?></div>
											</div>
										</div>
										<div class="col-6">
											<div class="status-kv">
												<div class="text-muted small">Sisa</div>
												<div class="fw-semibold"><?php echo rupiah(max(0, (float) $result->total - (float) $result->paid_amount)); ?></div>
											</div>
										</div>
									</div>
								<?php endif; ?>

								<div class="status-kv mt-3">
									<div class="text-muted small">Catatan</div>
									<div><?php echo $result->notes ? e($result->notes) : '-'; ?></div>
								</div>
							</div>
						</div>

						<div class="feature-card bg-light p-3 mt-4">
							<div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2">
								<div class="small text-muted">Butuh bantuan? Chat admin via WhatsApp (ikon hijau).</div>
								<a class="btn btn-outline-dark btn-sm" href="<?php echo site_url('beranda#reservasi'); ?>">Buat Reservasi Baru</a>
							</div>
						</div>
					<?php endif; ?>
				</div>

				<div class="text-center small text-muted mt-3">
					Admin kelola order di <a href="<?php echo site_url('admin'); ?>">/admin</a>.
				</div>
			</div>
		</div>
	</div>
</section>

<?php $this->load->view('public/_footer', get_defined_vars()); ?>
