<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php $this->load->view('public/_header', get_defined_vars()); ?>

<section class="page-hero">
	<div class="container py-5">
		<div class="row align-items-center g-4">
			<div class="col-lg-8">
				<div class="small text-muted">Kebijakan</div>
				<h1 class="display-6 fw-extrabold heading-bubble title-outline mb-2"><?php echo isset($page) && $page ? e($page->title) : 'Syarat &amp; Ketentuan'; ?></h1>
				<div class="text-muted">Dokumen ini menjelaskan aturan layanan, tanggung jawab pelanggan, dan kebijakan umum Loundri Express.</div>
				<div class="d-flex flex-wrap gap-2 mt-3">
					<span class="footer-badge">Transparan</span>
					<span class="footer-badge">Aman</span>
					<span class="footer-badge">Mudah dipahami</span>
				</div>
			</div>
			<div class="col-lg-4">
				<div class="feature-card bg-white p-4">
					<div class="d-flex align-items-start gap-3">
						<div class="icon-bubble">
							<svg width="22" height="22" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
								<path d="M7 3h10v18H7V3Z" stroke="#0ea5a3" stroke-width="2"/>
								<path d="M9 7h6M9 11h6M9 15h4" stroke="#0ea5a3" stroke-width="2" stroke-linecap="round"/>
							</svg>
						</div>
						<div>
							<div class="fw-semibold mb-1">Ringkasan</div>
							<div class="small text-muted mb-2">Harap baca sebelum reservasi/order.</div>
							<div class="small text-muted">
								Terakhir diperbarui:
								<?php echo isset($page) && $page && $page->updated_at ? e(date('d M Y', strtotime($page->updated_at))) : e(date('d M Y')); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="section-sm">
	<div class="container">
		<div class="row g-4">
			<div class="col-lg-4">
				<div class="feature-card bg-white p-4 toc position-sticky" style="top: 90px;">
					<div class="fw-semibold mb-2">Daftar Isi</div>
					<?php if (isset($page) && $page): ?>
						<div class="small text-muted">Konten di halaman ini bisa diubah dari admin.</div>
					<?php else: ?>
						<div class="d-grid gap-2 small">
							<a href="#umum">1. Ketentuan Umum</a>
							<a href="#reservasi">2. Reservasi &amp; Penjemputan</a>
							<a href="#pengerjaan">3. Proses &amp; Estimasi</a>
							<a href="#pembayaran">4. Pembayaran</a>
							<a href="#barang">5. Barang Hilang/Rusak</a>
							<a href="#larangan">6. Larangan &amp; Penolakan</a>
							<a href="#privasi">7. Privasi Data</a>
						</div>
					<?php endif; ?>
					<hr class="my-3">
					<div class="small text-muted">
						Punya pertanyaan? Chat via WhatsApp (ikon hijau di kanan bawah).
					</div>
				</div>
			</div>

			<div class="col-lg-8">
				<?php if (isset($page) && $page): ?>
					<div class="card shadow-soft border-0">
						<div class="card-body p-4 p-lg-5">
							<div class="prose">
								<?php echo $page->content_html; ?>
							</div>
						</div>
					</div>
				<?php else: ?>
				<div class="accordion shadow-soft" id="termsAccordion">
					<div class="accordion-item" id="umum">
						<h2 class="accordion-header" id="headingOne">
							<button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
								1. Ketentuan Umum
							</button>
						</h2>
						<div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#termsAccordion">
							<div class="accordion-body text-muted">
								<ol class="mb-0">
									<li>Loundri Express menyediakan layanan laundry kiloan &amp; satuan (sesuai layanan yang tersedia).</li>
									<li>Dengan melakukan reservasi/order, Anda dianggap menyetujui syarat &amp; ketentuan ini.</li>
									<li>Kebijakan dapat berubah sewaktu-waktu dan versi terbaru berlaku saat reservasi/order dibuat.</li>
								</ol>
							</div>
						</div>
					</div>

					<div class="accordion-item" id="reservasi">
						<h2 class="accordion-header" id="headingTwo">
							<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
								2. Reservasi &amp; Penjemputan
							</button>
						</h2>
						<div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#termsAccordion">
							<div class="accordion-body text-muted">
								<ol class="mb-0">
									<li>Pastikan nomor WhatsApp aktif untuk konfirmasi penjemputan.</li>
									<li>Waktu penjemputan bersifat estimasi dan bergantung pada ketersediaan kurir serta kondisi lalu lintas.</li>
									<li>Jika alamat sulit diakses, mohon berikan patokan/notes yang jelas.</li>
								</ol>
							</div>
						</div>
					</div>

					<div class="accordion-item" id="pengerjaan">
						<h2 class="accordion-header" id="headingThree">
							<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
								3. Proses &amp; Estimasi
							</button>
						</h2>
						<div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#termsAccordion">
							<div class="accordion-body text-muted">
								<ol class="mb-0">
									<li>Estimasi selesai mengikuti layanan yang dipilih dan antrian pengerjaan.</li>
									<li>Untuk pakaian dengan instruksi khusus (mis. dry clean/handwash), mohon tulis pada catatan.</li>
									<li>Perbedaan warna/tekstur kain bisa terjadi karena kondisi bahan, usia pakaian, atau noda lama.</li>
								</ol>
							</div>
						</div>
					</div>

					<div class="accordion-item" id="pembayaran">
						<h2 class="accordion-header" id="headingFour">
							<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
								4. Pembayaran
							</button>
						</h2>
						<div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#termsAccordion">
							<div class="accordion-body text-muted">
								<ol class="mb-0">
									<li>Harga mengikuti daftar layanan yang berlaku (tertera di beranda/admin).</li>
									<li>Pembayaran dapat dilakukan sesuai metode yang tersedia (cash/transfer/dll).</li>
									<li>Mohon simpan bukti pembayaran untuk mempercepat verifikasi.</li>
								</ol>
							</div>
						</div>
					</div>

					<div class="accordion-item" id="barang">
						<h2 class="accordion-header" id="headingFive">
							<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
								5. Barang Hilang/Rusak
							</button>
						</h2>
						<div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive" data-bs-parent="#termsAccordion">
							<div class="accordion-body text-muted">
								<ol class="mb-0">
									<li>Harap tidak menyertakan barang berharga (uang, perhiasan, elektronik) dalam cucian.</li>
									<li>Jika terjadi komplain, laporkan maksimal 1x24 jam setelah pesanan diterima.</li>
									<li>Ganti rugi (jika ada) mengikuti hasil pengecekan internal dan kebijakan yang disepakati.</li>
								</ol>
							</div>
						</div>
					</div>

					<div class="accordion-item" id="larangan">
						<h2 class="accordion-header" id="headingSix">
							<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
								6. Larangan &amp; Penolakan
							</button>
						</h2>
						<div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix" data-bs-parent="#termsAccordion">
							<div class="accordion-body text-muted">
								<ol class="mb-0">
									<li>Kami dapat menolak cucian yang mengandung bahan berbahaya, tajam, atau berpotensi merusak mesin.</li>
									<li>Cucian dengan kontaminasi berat (mis. oli/cairan kimia) dapat dikenakan perlakuan khusus atau ditolak.</li>
								</ol>
							</div>
						</div>
					</div>

					<div class="accordion-item" id="privasi">
						<h2 class="accordion-header" id="headingSeven">
							<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
								7. Privasi Data
							</button>
						</h2>
						<div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven" data-bs-parent="#termsAccordion">
							<div class="accordion-body text-muted">
								<ol class="mb-0">
									<li>Data yang Anda isi (nama, alamat, WhatsApp) digunakan untuk proses layanan &amp; konfirmasi.</li>
									<li>Kami tidak menjual data pelanggan kepada pihak ketiga.</li>
									<li>Anda dapat meminta penghapusan data reservasi dengan menghubungi admin.</li>
								</ol>
							</div>
						</div>
					</div>
				</div>
				<?php endif; ?>

				<div class="feature-card bg-white p-4 mt-4">
					<div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-3">
						<div>
							<div class="fw-semibold mb-1">Butuh bantuan?</div>
							<div class="text-muted small">Kami siap membantu pertanyaan seputar layanan, harga, atau komplain.</div>
						</div>
						<a class="btn btn-brand text-white" href="<?php echo site_url('beranda#reservasi'); ?>">Buat Reservasi</a>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<?php $this->load->view('public/_footer', get_defined_vars()); ?>
