<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="card">
	<div class="card-body">
		<?php if (validation_errors()): ?>
			<div class="alert alert-danger"><?php echo validation_errors(); ?></div>
		<?php endif; ?>

		<form method="post">
			<div class="mb-3">
				<label class="form-label">Nama layanan</label>
				<input type="text" class="form-control" name="name" value="<?php echo set_value('name', $row ? $row->name : ''); ?>" required>
			</div>
			<div class="mb-3">
				<label class="form-label">Satuan (kg/pcs)</label>
				<input type="text" class="form-control" name="unit" value="<?php echo set_value('unit', $row ? $row->unit : 'kg'); ?>" required>
			</div>
			<div class="mb-3">
				<label class="form-label">Harga</label>
				<input type="number" step="0.01" class="form-control" name="price" value="<?php echo set_value('price', $row ? $row->price : ''); ?>" required>
			</div>
			<div class="d-flex gap-2">
				<button class="btn btn-primary" type="submit"><?php echo $mode === 'edit' ? 'Simpan' : 'Tambah'; ?></button>
				<a class="btn btn-outline-secondary" href="<?php echo site_url('services'); ?>">Kembali</a>
			</div>
		</form>
	</div>
</div>

