<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
	<div class="text-muted">Kelola layanan dan harga</div>
	<a href="<?php echo site_url('services/create'); ?>" class="btn btn-primary">Tambah</a>
</div>

<div class="card">
	<div class="table-responsive">
		<table class="table table-striped mb-0">
			<thead>
				<tr>
					<th>Nama</th>
					<th>Satuan</th>
					<th>Harga</th>
					<th></th>
				</tr>
			</thead>
			<tbody>
				<?php if (!$rows): ?>
					<tr><td colspan="4" class="text-center text-muted py-4">Belum ada layanan</td></tr>
				<?php endif; ?>
				<?php foreach ($rows as $r): ?>
					<tr>
						<td><?php echo e($r->name); ?></td>
						<td><?php echo e($r->unit); ?></td>
						<td><?php echo rupiah($r->price); ?></td>
						<td class="text-end">
							<a class="btn btn-sm btn-outline-secondary" href="<?php echo site_url('services/edit/' . $r->id); ?>">Edit</a>
							<form method="post" action="<?php echo site_url('services/delete/' . $r->id); ?>" class="d-inline" onsubmit="return confirm('Hapus layanan ini?')">
								<button type="submit" class="btn btn-sm btn-outline-danger">Hapus</button>
							</form>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>
	</div>
</div>

