-- Update script (tanpa drop data)
-- Import via phpMyAdmin pada database `loundri`
-- Penting: pastikan sudah memilih database yang benar di phpMyAdmin (agar tidak kena error #1046).

CREATE TABLE IF NOT EXISTS pages (
	id INT UNSIGNED NOT NULL AUTO_INCREMENT,
	slug VARCHAR(50) NOT NULL,
	title VARCHAR(150) NOT NULL,
	content_html MEDIUMTEXT NOT NULL,
	created_at DATETIME NOT NULL,
	updated_at DATETIME NOT NULL,
	PRIMARY KEY (id),
	UNIQUE KEY uq_pages_slug (slug)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO pages (slug, title, content_html, created_at, updated_at) VALUES
(
	'terms',
	'Syarat & Ketentuan',
	CONCAT(
		'<h2>Ketentuan Umum</h2>',
		'<ul>',
		'<li>Dengan melakukan reservasi/order, Anda dianggap menyetujui syarat & ketentuan ini.</li>',
		'<li>Estimasi selesai mengikuti layanan yang dipilih dan antrian pengerjaan.</li>',
		'<li>Kebijakan dapat berubah sewaktu-waktu dan versi terbaru berlaku saat reservasi/order dibuat.</li>',
		'</ul>',
		'<h2>Reservasi & Penjemputan</h2>',
		'<ul>',
		'<li>Pastikan nomor WhatsApp aktif untuk konfirmasi penjemputan.</li>',
		'<li>Waktu penjemputan bersifat estimasi dan bergantung pada ketersediaan kurir serta kondisi lalu lintas.</li>',
		'</ul>',
		'<h2>Barang Berharga</h2>',
		'<ul>',
		'<li>Harap tidak menyertakan barang berharga (uang, perhiasan, elektronik) di dalam cucian.</li>',
		'<li>Komplain maksimal 1x24 jam setelah pesanan diterima.</li>',
		'</ul>',
		'<h2>Privasi</h2>',
		'<p>Data pelanggan digunakan untuk proses layanan & konfirmasi, dan tidak diperjualbelikan.</p>'
	),
	NOW(),
	NOW()
)
ON DUPLICATE KEY UPDATE
	title = VALUES(title),
	content_html = VALUES(content_html),
	updated_at = VALUES(updated_at);
