<?php
class AuthController extends Controller {
    private $userModel;
    
    public function __construct() {
        $this->userModel = $this->model('User');
    }

    public function login() {
        // If already logged in, redirect
        if (isset($_SESSION['user_id'])) {
            redirect($_SESSION['role'] . '/dashboard');
            return;
        }

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $data = [
                'username' => sanitize($_POST['username']),
                'password' => trim($_POST['password']),
                'username_err' => '',
                'password_err' => ''
            ];

            // Validate username
            if (empty($data['username'])) {
                $data['username_err'] = 'Username tidak boleh kosong';
            }

            // Validate password
            if (empty($data['password'])) {
                $data['password_err'] = 'Password tidak boleh kosong';
            }

            // If no errors, attempt login
            if (empty($data['username_err']) && empty($data['password_err'])) {
                $loggedInUser = $this->userModel->login($data['username'], $data['password']);

                if ($loggedInUser === 'NOT_ACTIVE') {
                    $data['password_err'] = 'Akun Anda tidak aktif. Hubungi administrator.';
                    $this->view('auth/login', $data);
                } elseif ($loggedInUser) {
                    $this->createUserSession($loggedInUser);
                } else {
                    $data['password_err'] = 'Username atau password salah';
                    $this->view('auth/login', $data);
                }
            } else {
                $this->view('auth/login', $data);
            }
        } else {
            // Initial load - show login form
            $data = [
                'username' => '',
                'password' => '',
                'username_err' => '',
                'password_err' => ''
            ];
            $this->view('auth/login', $data);
        }
    }

    public function createUserSession($user) {
        // Prevent Session Fixation
        session_regenerate_id(true);

        $_SESSION['user_id'] = $user->id;
        $_SESSION['username'] = $user->username;
        $_SESSION['name'] = isset($user->name) ? $user->name : $user->username;
        $_SESSION['role'] = $user->role;
        $_SESSION['school_class'] = isset($user->school_class) ? $user->school_class : (isset($user->kelas_id) ? $user->kelas_id : null); 
        
        // Anti-Hijacking: Bind to User Agent
        $_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
        $_SESSION['last_regen'] = time();

        // Log Login
        $this->userModel->logActivity($user->id, 'Login', 'User logged in');

        redirect($user->role . '/dashboard');
    }

    public function logout() {
        unset($_SESSION['user_id']);
        unset($_SESSION['username']);
        unset($_SESSION['name']);
        unset($_SESSION['role']);
        unset($_SESSION['school_class']);
        session_destroy();
        redirect('auth/login');
    }
}
