<?php
class ClassController extends Controller {
    private $classModel;

    public function __construct() {
        AuthMiddleware::check(['admin']);
        $this->classModel = $this->model('ClassModel');
    }

    // Default method called by router if no method specified
    public function dashboard() {
        $this->index();
    }

    public function index() {
        $data = [
            'title' => 'Kelola Kelas',
            'active_menu' => 'classes',
            'classes' => $this->classModel->getAllClasses()
        ];
        $this->view('layouts/header', $data);
        $this->view('admin/classes', $data);
        $this->view('layouts/footer');
    }

    public function store() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $name = trim($_POST['name']);
            if (empty($name)) {
                set_flash('Nama kelas tidak boleh kosong', 'danger');
            } elseif ($this->classModel->getClassByName($name)) {
                set_flash('Nama kelas sudah ada', 'danger');
            } else {
                if ($this->classModel->addClass($name)) {
                    set_flash('Kelas berhasil ditambahkan', 'success');
                } else {
                    set_flash('Gagal menambahkan kelas', 'danger');
                }
            }
        }
        redirect('class');
    }

    public function delete($id) {
        if ($this->classModel->deleteClass($id)) {
            set_flash('Kelas berhasil dihapus', 'success');
        } else {
            set_flash('Gagal menghapus kelas', 'danger');
        }
        redirect('class');
    }

    // --- Detail & Member Management ---

    public function detail($id) {
        $class = $this->classModel->getClassById($id);
        if (!$class) {
            set_flash('Kelas tidak ditemukan', 'danger');
            redirect('class');
            return;
        }

        $members = $this->classModel->getStudentsByClassId($id);
        $available_students = $this->classModel->getAvailableStudents();

        $data = [
            'title' => 'Detail Kelas - ' . $class->name,
            'active_menu' => 'classes',
            'class' => $class,
            'members' => $members,
            'available_students' => $available_students
        ];

        $this->view('layouts/header', $data);
        $this->view('admin/class_detail', $data);
        $this->view('layouts/footer');
    }

    public function add_student() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $class_id = $_POST['class_id'];
            $student_id = $_POST['student_id'];
            
            if ($this->classModel->addStudentToClass($student_id, $class_id)) {
                set_flash('Siswa berhasil ditambahkan ke kelas', 'success');
            } else {
                set_flash('Gagal menambahkan siswa', 'danger');
            }
            redirect('class/detail/' . $class_id);
        }
    }

    public function remove_student($student_id, $class_id) {
        if ($this->classModel->removeStudentFromClass($student_id)) {
            set_flash('Siswa dikeluarkan dari kelas', 'success');
        } else {
            set_flash('Gagal mengeluarkan siswa', 'danger');
        }
        redirect('class/detail/' . $class_id);
    }
}
