<?php
class SubjectController extends Controller {
    private $subjectModel;

    public function __construct() {
        AuthMiddleware::check(['admin']);
        $this->subjectModel = $this->model('SubjectModel');
    }

    // Default alias
    public function dashboard() {
        $this->index();
    }

    public function index() {
        $data = [
            'title' => 'Kelola Mata Pelajaran',
            'active_menu' => 'subjects',
            'subjects' => $this->subjectModel->getAllSubjects()
        ];
        $this->view('layouts/header', $data);
        $this->view('admin/subjects', $data);
        $this->view('layouts/footer');
    }

    public function store() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $name = trim($_POST['name']);
            if (empty($name)) {
                set_flash('Nama mata pelajaran tidak boleh kosong', 'danger');
            } elseif ($this->subjectModel->getSubjectByName($name)) {
                set_flash('Mata pelajaran sudah ada', 'danger');
            } else {
                if ($this->subjectModel->addSubject($name)) {
                    set_flash('Mata pelajaran berhasil ditambahkan', 'success');
                } else {
                    set_flash('Gagal menambahkan mata pelajaran', 'danger');
                }
            }
        }
        redirect('subject');
    }

    public function delete($id) {
        if ($this->subjectModel->deleteSubject($id)) {
            set_flash('Mata pelajaran berhasil dihapus', 'success');
        } else {
            set_flash('Gagal menghapus mata pelajaran', 'danger');
        }
        redirect('subject');
    }
}
