<?php
function redirect($page) {
    header('location: ' . BASE_URL . $page);
}

// Check session to prevent unauthorized access
function check_session($roles = []) {
    if (!isset($_SESSION['user_id'])) {
        redirect('auth/login');
        exit;
    }
    
    if (!empty($roles)) {
        if (!in_array($_SESSION['role'], $roles)) {
            // If user has no access, redirect to their dashboard or logout
            redirect($_SESSION['role'] . '/dashboard'); 
            exit;
        }
    }
}

// Flash message helper (simplified)
function set_flash($message, $type = 'success') {
    $_SESSION['flash'] = [
        'message' => $message,
        'type' => $type
    ];
}

function get_flash() {
    if (isset($_SESSION['flash'])) {
        echo '<div class="alert alert-' . $_SESSION['flash']['type'] . ' alert-dismissible fade show" role="alert">
                ' . $_SESSION['flash']['message'] . '
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>';
        unset($_SESSION['flash']);
    }
}
