<?php
class AuthMiddleware {
    // Check if user is logged in and has specific role
    public static function check($roles = []) {
        // Ensure session is started
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }

        if (!isset($_SESSION['user_id'])) {
            set_flash('Please login to access this page.', 'danger');
            header('location: ' . BASE_URL . 'auth/login');
            exit;
        }

        // Anti-Session Hijacking: Check User Agent
        if (isset($_SESSION['user_agent']) && $_SESSION['user_agent'] !== $_SERVER['HTTP_USER_AGENT']) {
            session_unset();
            session_destroy();
            header('location: ' . BASE_URL . 'auth/login');
            exit;
        }
        
        // Regenerate Session ID periodically (optional, but good practice)
        if (!isset($_SESSION['last_regen'])) {
            $_SESSION['last_regen'] = time();
        } elseif (time() - $_SESSION['last_regen'] > 300) { // Every 5 minutes
            session_regenerate_id(true);
            $_SESSION['last_regen'] = time();
        }
        
        if (!empty($roles)) {
            if (!in_array($_SESSION['role'], $roles)) {
                // If user has no access, redirect to their dashboard or logout
                header('location: ' . BASE_URL . $_SESSION['role'] . '/dashboard'); 
                exit;
            }
        }

        // --- Activity Tracker ---
        // Update DB at most once per minute
        if (isset($_SESSION['user_id'])) {
             if (!isset($_SESSION['last_activity_update']) || (time() - $_SESSION['last_activity_update'] > 60)) {
                // We assume Database class is autoloaded or available
                // If not, we might need to require it, but usually standard MVC autoloads core.
                // However, Middleware is static, so we treat it carefully.
                 try {
                    $db = new Database;
                    $db->query("UPDATE users SET last_activity = NOW() WHERE id = :id");
                    $db->bind(':id', $_SESSION['user_id']);
                    $db->execute();
                    $_SESSION['last_activity_update'] = time();
                 } catch (Exception $e) {
                     // Silently fail if DB issue to not block access
                 }
             }
        }
    }

    public static function guest() {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        if (isset($_SESSION['user_id'])) {
            header('location: ' . BASE_URL . $_SESSION['role'] . '/dashboard');
            exit;
        }
    }
}
