<?php
class ClassModel {
    private $db;

    public function __construct() {
        $this->db = new Database;
    }

    public function getAllClasses() {
        $this->db->query("SELECT * FROM classes ORDER BY name ASC");
        return $this->db->resultSet();
    }

    public function getClassById($id) {
        $this->db->query("SELECT * FROM classes WHERE id = :id");
        $this->db->bind(':id', $id);
        return $this->db->single();
    }

    public function addClass($name) {
        $this->db->query("INSERT INTO classes (name) VALUES (:name)");
        $this->db->bind(':name', $name);
        return $this->db->execute();
    }

    public function deleteClass($id) {
        $this->db->query("DELETE FROM classes WHERE id = :id");
        $this->db->bind(':id', $id);
        return $this->db->execute();
    }
    
    // Get students in a class
    public function getStudentsByClassId($class_id) {
        $this->db->query("SELECT * FROM users WHERE class_id = :class_id AND role = 'siswa' ORDER BY name ASC");
        $this->db->bind(':class_id', $class_id);
        return $this->db->resultSet();
    }
    
    // Get students available to be added (no class assigned)
    public function getAvailableStudents() {
        $this->db->query("SELECT * FROM users WHERE (class_id IS NULL OR class_id = 0) AND role = 'siswa' ORDER BY name ASC");
        return $this->db->resultSet();
    }

    // Add student to class
    public function addStudentToClass($student_id, $class_id) {
        $this->db->query("UPDATE users SET class_id = :class_id WHERE id = :student_id");
        $this->db->bind(':class_id', $class_id);
        $this->db->bind(':student_id', $student_id);
        return $this->db->execute();
    }

    // Remove student from class
    public function removeStudentFromClass($student_id) {
        $this->db->query("UPDATE users SET class_id = NULL WHERE id = :student_id");
        $this->db->bind(':student_id', $student_id);
        return $this->db->execute();
    }

    // Check if class name exists (for validation)
    public function getClassByName($name) {
        $this->db->query("SELECT * FROM classes WHERE name = :name");
        $this->db->bind(':name', $name);
        return $this->db->single();
    }
}
