<?php
class SchoolSettings {
    private $db;

    public function __construct() {
        $this->db = new Database;
    }

    public function getSetting($key) {
        $this->db->query("SELECT setting_value FROM school_settings WHERE setting_key = :key");
        $this->db->bind(':key', $key);
        $row = $this->db->single();
        return $row ? $row->setting_value : null;
    }

    public function getAllSettings() {
        $this->db->query("SELECT * FROM school_settings");
        $results = $this->db->resultSet();
        $settings = [];
        foreach ($results as $row) {
            $settings[$row->setting_key] = $row->setting_value;
        }
        return $settings;
    }

    public function updateSetting($key, $value) {
        $this->db->query("INSERT INTO school_settings (setting_key, setting_value) 
                         VALUES (:key, :value) 
                         ON DUPLICATE KEY UPDATE setting_value = :value");
        $this->db->bind(':key', $key);
        $this->db->bind(':value', $value);
        return $this->db->execute();
    }
}
