<?php
class SubjectModel {
    private $db;

    public function __construct() {
        $this->db = new Database;
    }

    public function getAllSubjects() {
        $this->db->query("SELECT * FROM subjects ORDER BY name ASC");
        return $this->db->resultSet();
    }

    public function getSubjectById($id) {
        $this->db->query("SELECT * FROM subjects WHERE id = :id");
        $this->db->bind(':id', $id);
        return $this->db->single();
    }

    public function addSubject($name) {
        $this->db->query("INSERT INTO subjects (name) VALUES (:name)");
        $this->db->bind(':name', $name);
        try {
            return $this->db->execute();
        } catch (PDOException $e) {
            return false;
        }
    }

    public function deleteSubject($id) {
        $this->db->query("DELETE FROM subjects WHERE id = :id");
        $this->db->bind(':id', $id);
        return $this->db->execute();
    }
    
    public function getSubjectByName($name) {
        $this->db->query("SELECT * FROM subjects WHERE name = :name");
        $this->db->bind(':name', $name);
        return $this->db->single();
    }
}
