<div class="d-flex justify-content-between align-items-center mb-3">
    <h2>Detail Kelas: <?php echo $data['class']->name; ?></h2>
    <div>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addStudentModal">
            <i class="fas fa-plus"></i> Tambah Siswa ke Kelas
        </button>
        <a href="<?php echo BASE_URL; ?>class" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Daftar Anggota Kelas</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th style="width: 50px;">No</th>
                        <th>NIS/Username</th>
                        <th>Nama Lengkap</th>
                        <th style="width: 150px;">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($data['members'])): ?>
                        <tr><td colspan="4" class="text-center">Belum ada siswa di kelas ini.</td></tr>
                    <?php else: ?>
                        <?php $no = 1; foreach($data['members'] as $member): ?>
                            <tr>
                                <td><?php echo $no++; ?></td>
                                <td><?php echo $member->username; ?></td>
                                <td><?php echo $member->name; ?></td>
                                <td>
                                    <a href="<?php echo BASE_URL; ?>class/remove_student/<?php echo $member->id; ?>/<?php echo $data['class']->id; ?>" class="btn btn-sm btn-warning" onclick="return confirm('Keluarkan siswa ini dari kelas?');">
                                        <i class="fas fa-minus-circle"></i> Keluarkan
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Tambah Siswa ke Kelas -->
<div class="modal fade" id="addStudentModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo BASE_URL; ?>class/add_student" method="POST">
                <input type="hidden" name="class_id" value="<?php echo $data['class']->id; ?>">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Siswa ke Kelas</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Pilih Siswa (Yang belum punya kelas)</label>
                        <select name="student_id" class="form-select" required>
                            <option value="">-- Pilih Siswa --</option>
                            <?php foreach($data['available_students'] as $student): ?>
                                <option value="<?php echo $student->id; ?>"><?php echo $student->name; ?> (<?php echo $student->username; ?>)</option>
                            <?php endforeach; ?>
                        </select>
                        <div class="form-text">Hanya siswa yang belum masuk kelas manapun yang muncul di sini.</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Tambahkan</button>
                </div>
            </form>
        </div>
    </div>
</div>
