<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Log Aktivitas Siswa</h1>
    <button onclick="window.print()" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm"><i class="fas fa-print fa-sm text-white-50"></i> Print Log</button>
</div>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Rekaman Aktivitas Terbaru (100 Terakhir)</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>Waktu</th>
                        <th>User</th>
                        <th>Role</th>
                        <th>Aktivitas</th>
                        <th>Keterangan</th>
                        <th>IP Address</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($data['logs'] as $log): ?>
                        <tr>
                            <td><?php echo $log->created_at; ?></td>
                            <td><?php echo $log->username; ?></td>
                            <td><span class="badge bg-info"><?php echo $log->role; ?></span></td>
                            <td>
                                <?php 
                                    $color = 'secondary';
                                    if($log->aktivitas == 'Login') $color = 'primary';
                                    if($log->aktivitas == 'Mulai Ujian') $color = 'info';
                                    if($log->aktivitas == 'Selesai Ujian') $color = 'success';
                                    if(strpos($log->aktivitas, 'Keluar') !== false || strpos($log->aktivitas, 'Fokus') !== false) $color = 'warning';
                                    if(strpos($log->aktivitas, 'Ban') !== false) $color = 'danger';
                                ?>
                                <span class="badge bg-<?php echo $color; ?>"><?php echo $log->aktivitas; ?></span>
                            </td>
                            <td><?php echo $log->keterangan; ?></td>
                            <td><?php echo $log->ip_address; ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
