<div class="d-flex justify-content-between align-items-center mb-3">
    <h2><i class="fas fa-id-card"></i> Cetak Kartu Ujian</h2>
</div>

<div class="card">
    <div class="card-body">
        <p class="text-muted">Pilih kelas untuk mencetak kartu ujian siswa</p>
        
        <form id="printCardForm" method="POST">
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Pilih Kelas <span class="text-danger">*</span></label>
                        <select name="class_id" id="class_select" class="form-select" required>
                            <option value="">-- Pilih Kelas --</option>
                            <?php foreach($data['classes'] as $cls): ?>
                                <option value="<?php echo $cls->id; ?>"><?php echo $cls->name; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="btn-group" role="group">
                        <button type="button" class="btn btn-primary" onclick="printCards()">
                            <i class="fas fa-print"></i> Tampilkan untuk Cetak
                        </button>
                        <button type="button" class="btn btn-success" onclick="downloadPDF()">
                            <i class="fas fa-download"></i> Download PDF
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header bg-info text-white">
        <h6 class="mb-0"><i class="fas fa-info-circle"></i> Informasi</h6>
    </div>
    <div class="card-body">
        <ul>
            <li><strong>Tampilkan untuk Cetak:</strong> Buka kartu di tab baru, gunakan Ctrl+P untuk print</li>
            <li><strong>Download PDF:</strong> Download kartu dalam format PDF siap cetak</li>
            <li>Kartu menampilkan foto siswa, biodata, dan informasi kelas</li>
        </ul>
    </div>
</div>

<script>
function printCards() {
    var classId = document.getElementById('class_select').value;
    if (!classId) {
        alert('Pilih kelas terlebih dahulu!');
        return;
    }
    
    var form = document.getElementById('printCardForm');
    form.action = '<?php echo BASE_URL; ?>admin/generate_cards';
    form.target = '_blank';
    form.submit();
}

function downloadPDF() {
    var classId = document.getElementById('class_select').value;
    if (!classId) {
        alert('Pilih kelas terlebih dahulu!');
        return;
    }
    
    var form = document.getElementById('printCardForm');
    form.action = '<?php echo BASE_URL; ?>admin/download_cards_pdf';
    form.target = '_self';
    form.submit();
}
</script>
