<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kartu Ujian - <?php echo $data['class']->name; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        @media print {
            .no-print {
                display: none;
            }
            .card-container {
                page-break-inside: avoid;
                page-break-after: always;
            }
            body {
                margin: 0;
                padding: 10mm;
            }
        }
        
        body {
            background-color: #f5f5f5;
            font-family: Arial, sans-serif;
        }
        
        .card-container {
            width: 85mm;
            height: 54mm;
            background: white;
            border: 2px solid #333;
            border-radius: 8px;
            margin: 10px auto;
            padding: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            position: relative;
            overflow: hidden;
        }
        
        .card-header-bar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 4px 8px;
            margin: -8px -8px 6px -8px;
            text-align: center;
        }
        
        .card-header-bar h6 {
            margin: 0;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .card-body-content {
            display: flex;
            gap: 8px;
        }
        
        .photo-section {
            flex-shrink: 0;
        }
        
        .student-photo {
            width: 3cm;
            height: 4cm;
            border: 2px solid #ddd;
            object-fit: cover;
            background: #f8f9fa;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #999;
            font-size: 10px;
        }
        
        .info-section {
            flex: 1;
            font-size: 9px;
        }
        
        .info-row {
            margin-bottom: 3px;
            display: flex;
        }
        
        .info-label {
            font-weight: bold;
            width: 60px;
            flex-shrink: 0;
        }
        
        .info-value {
            flex: 1;
        }
        
        .card-footer-bar {
            position: absolute;
            bottom: 8px;
            left: 8px;
            right: 8px;
            text-align: center;
            font-size: 8px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 4px;
        }
        
        .print-btn {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
        }
    </style>
</head>
<body>
    <button onclick="window.print()" class="btn btn-primary print-btn no-print">
        <i class="fas fa-print"></i> Cetak Semua Kartu
    </button>
    
    <div class="container-fluid mt-4 no-print">
        <h4 class="text-center mb-4">Kartu Ujian - Kelas <?php echo $data['class']->name; ?></h4>
        <p class="text-center text-muted">Total: <?php echo count($data['students']); ?>  siswa</p>
    </div>
    
    <?php if (empty($data['students'])): ?>
       <div class="alert alert-warning text-center mt-5">
            Tidak ada siswa di kelas ini.
        </div>
    <?php else: ?>
        <?php foreach($data['students'] as $student): ?>
            <div class="card-container">
                <div class="card-header-bar">
                    <h6>KARTU PESERTA UJIAN</h6>
                </div>
                
                <div class="card-body-content">
                    <div class="photo-section">
                        <?php if (!empty($student->foto)): ?>
                            <img src="<?php echo BASE_URL; ?>uploads/students/<?php echo $student->foto; ?>" 
                                 alt="Foto" 
                                 class="student-photo">
                        <?php else: ?>
                            <div class="student-photo">
                                <i class="fas fa-user" style="font-size: 40px;"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="info-section">
                        <div class="info-row">
                            <div class="info-label">NISN</div>
                            <div class="info-value">: <?php echo $student->nisn ?? $student->username; ?></div>
                        </div>
                        <div class="info-row">
                            <div class="info-label">Nama</div>
                            <div class="info-value">: <strong><?php echo strtoupper($student->name); ?></strong></div>
                        </div>
                        <div class="info-row">
                            <div class="info-label">Kelas</div>
                            <div class="info-value">: <?php echo $data['class']->name; ?></div>
                        </div>
                        <div class="info-row">
                            <div class="info-label">TTL</div>
                            <div class="info-value">: <?php 
                                if (!empty($student->tempat_lahir) && !empty($student->tanggal_lahir)) {
                                    echo $student->tempat_lahir . ', ' . date('d-m-Y', strtotime($student->tanggal_lahir));
                                } else {
                                    echo '-';
                                }
                            ?></div>
                        </div>
                        <div class="info-row">
                            <div class="info-label">L/P</div>
                            <div class="info-value">: <?php echo $student->jenis_kelamin ?? '-'; ?></div>
                        </div>
                        <div class="info-row" style="margin-top: 8px;">
                            <div class="info-value">
                                <div style="border: 1px solid #ddd; height: 20px; background: white; padding: 2px;">
                                    <small style="color: #999;">Tanda Tangan Peserta:</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card-footer-bar">
                    Kartu ini harus dibawa saat ujian | Tahun Ajaran <?php echo date('Y'); ?>/<?php echo date('Y') + 1; ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</body>
</html>
