<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-school"></i> Pengaturan Sekolah
        </h1>
    </div>

    <?php get_flash(); ?>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-cog"></i> Konfigurasi Sekolah
                    </h6>
                </div>
                <div class="card-body">
                    <form action="<?php echo BASE_URL; ?>admin/update_school_settings" method="POST" enctype="multipart/form-data">
                        <!-- School Name -->
                        <div class="form-group">
                            <label for="school_name">
                                <i class="fas fa-building"></i> Nama Sekolah
                                <span class="text-danger">*</span>
                            </label>
                            <input type="text" 
                                   class="form-control" 
                                   id="school_name" 
                                   name="school_name" 
                                   value="<?php echo htmlspecialchars($data['school_name']); ?>" 
                                   required 
                                   placeholder="Masukkan nama sekolah">
                            <small class="form-text text-muted">
                                Nama sekolah akan ditampilkan di header dan kartu ujian
                            </small>
                        </div>

                        <!-- School Logo -->
                        <div class="form-group">
                            <label for="school_logo">
                                <i class="fas fa-image"></i> Logo Sekolah
                            </label>
                            
                            <!-- Logo Preview -->
                            <div class="mb-3">
                                <?php if (!empty($data['school_logo'])): ?>
                                    <div class="border rounded p-3 bg-light text-center">
                                        <img src="<?php echo BASE_URL; ?>uploads/school/<?php echo $data['school_logo']; ?>" 
                                             alt="Logo Sekolah" 
                                             class="img-thumbnail"
                                             id="logoPreview"
                                             style="max-height: 150px; max-width: 200px;">
                                        <p class="mt-2 mb-0 text-muted small">Logo saat ini</p>
                                    </div>
                                <?php else: ?>
                                    <div class="border rounded p-4 bg-light text-center" id="logoPreview">
                                        <i class="fas fa-image fa-3x text-muted mb-2"></i>
                                        <p class="mb-0 text-muted">Belum ada logo</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="custom-file">
                                <input type="file" 
                                       class="custom-file-input" 
                                       id="school_logo" 
                                       name="school_logo" 
                                       accept="image/jpeg,image/png,image/jpg"
                                       onchange="previewLogo(this)">
                                <label class="custom-file-label" for="school_logo">Pilih file logo...</label>
                            </div>
                            <small class="form-text text-muted">
                                Format: JPG, PNG (Max 2MB). Recommended: 200x200px atau ratio 1:1
                            </small>
                        </div>

                        <!-- Submit Button -->
                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan Pengaturan
                            </button>
                            <a href="<?php echo BASE_URL; ?>admin/dashboard" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card shadow mb-4 border-left-info">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">
                        <i class="fas fa-info-circle"></i> Informasi
                    </h6>
                </div>
                <div class="card-body">
                    <h6 class="font-weight-bold">Tentang Pengaturan Sekolah</h6>
                    <p class="small text-muted">
                        Halaman ini digunakan untuk mengatur identitas sekolah yang akan ditampilkan di seluruh sistem.
                    </p>
                    
                    <hr>
                    
                    <h6 class="font-weight-bold">Nama Sekolah</h6>
                    <ul class="small text-muted">
                        <li>Ditampilkan di header sistem</li>
                        <li>Digunakan di kartu ujian</li>
                        <li>Muncul di laporan hasil ujian</li>
                    </ul>
                    
                    <h6 class="font-weight-bold mt-3">Logo Sekolah</h6>
                    <ul class="small text-muted">
                        <li>Ditampilkan di header navbar</li>
                        <li>Format: JPG atau PNG</li>
                        <li>Ukuran maksimal: 2MB</li>
                        <li>Recommended: Kotak (1:1 ratio)</li>
                    </ul>
                    
                    <div class="alert alert-warning mt-3 mb-0">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>Penting!</strong> Perubahan akan langsung terlihat di seluruh sistem.
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Custom file input label update
$('#school_logo').on('change', function() {
    var fileName = $(this).val().split('\\').pop();
    $(this).next('.custom-file-label').html(fileName);
});

// Logo preview
function previewLogo(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        
        reader.onload = function(e) {
            var preview = document.getElementById('logoPreview');
            preview.innerHTML = '<img src="' + e.target.result + '" alt="Preview Logo" class="img-thumbnail" style="max-height: 150px; max-width: 200px;">';
            preview.innerHTML += '<p class="mt-2 mb-0 text-muted small">Preview logo baru</p>';
        }
        
        reader.readAsDataURL(input.files[0]);
    }
}
</script>
